/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.common;

import com.consol.citrus.TestCase;
import com.consol.citrus.common.TestLoader;
import com.consol.citrus.context.TestContextFactory;
import java.io.File;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.StringUtils;

public class XmlTestLoader
implements TestLoader {
    private TestCase testCase;
    private Class<?> testClass;
    private String testName;
    private String packageName;
    private ApplicationContext parentContext;
    private String contextFile;

    public XmlTestLoader(Class<?> testClass, String testName, String packageName, ApplicationContext parentContext) {
        this.testClass = testClass;
        this.testName = testName;
        this.packageName = packageName;
        this.parentContext = parentContext;
    }

    @Override
    public TestCase load() {
        if (this.testCase == null) {
            ApplicationContext ctx = this.loadApplicationContext();
            try {
                this.testCase = (TestCase)ctx.getBean(this.testName, TestCase.class);
                this.testCase.setTestClass(this.testClass);
                this.testCase.setPackageName(this.packageName);
            }
            catch (NoSuchBeanDefinitionException e) {
                throw ((TestContextFactory)this.parentContext.getBean(TestContextFactory.class)).getObject().handleError(this.testName, this.packageName, "Could not find test with name '" + this.testName + "'", (Exception)((Object)e));
            }
        }
        return this.testCase;
    }

    private ApplicationContext loadApplicationContext() {
        try {
            return new ClassPathXmlApplicationContext(new String[]{this.getContextFile(), "com/consol/citrus/spring/annotation-config-ctx.xml"}, true, this.parentContext);
        }
        catch (Exception e) {
            throw ((TestContextFactory)this.parentContext.getBean(TestContextFactory.class)).getObject().handleError(this.testName, this.packageName, "Failed to load test case", e);
        }
    }

    public String getContextFile() {
        if (StringUtils.hasText((String)this.contextFile)) {
            return this.contextFile;
        }
        return this.packageName.replace('.', File.separatorChar) + File.separator + this.testName + ".xml";
    }

    public void setContextFile(String contextFile) {
        this.contextFile = contextFile;
    }
}

