/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.channel.selector;

import com.consol.citrus.channel.selector.HeaderMatchingMessageSelector;
import com.consol.citrus.channel.selector.JsonPathPayloadMessageSelector;
import com.consol.citrus.channel.selector.MessageSelectorFactory;
import com.consol.citrus.channel.selector.PayloadMatchingMessageSelector;
import com.consol.citrus.channel.selector.RootQNameMessageSelector;
import com.consol.citrus.channel.selector.XpathPayloadMessageSelector;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.MessageSelectorBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.ApplicationContext;
import org.springframework.integration.core.MessageSelector;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class DispatchingMessageSelector
implements MessageSelector {
    private final Map<String, String> matchingHeaders;
    private final BeanFactory beanFactory;
    private final List<MessageSelectorFactory> factories = new ArrayList<MessageSelectorFactory>();
    private final TestContext context;

    public DispatchingMessageSelector(String selector, BeanFactory beanFactory, TestContext context) {
        this.beanFactory = beanFactory;
        this.context = context;
        this.matchingHeaders = MessageSelectorBuilder.withString(selector).toKeyValueMap();
        Assert.isTrue((this.matchingHeaders.size() > 0 ? 1 : 0) != 0, (String)"Invalid empty message selector");
        this.factories.add(new RootQNameMessageSelector.Factory());
        this.factories.add(new XpathPayloadMessageSelector.Factory());
        this.factories.add(new JsonPathPayloadMessageSelector.Factory());
        this.factories.add(new PayloadMatchingMessageSelector.Factory());
        if (beanFactory instanceof ApplicationContext) {
            Map factoryBeans = ((ApplicationContext)beanFactory).getBeansOfType(MessageSelectorFactory.class);
            this.factories.addAll(factoryBeans.values());
        }
        this.factories.parallelStream().filter(factory -> factory instanceof BeanFactoryAware).map(factory -> (BeanFactoryAware)factory).forEach(factory -> factory.setBeanFactory(beanFactory));
    }

    public boolean accept(Message<?> message) {
        return this.matchingHeaders.entrySet().stream().allMatch(entry -> this.factories.stream().filter(factory -> factory.supports((String)entry.getKey())).findAny().orElse(new HeaderMatchingMessageSelector.Factory()).create((String)entry.getKey(), (String)entry.getValue(), this.context).accept(message));
    }

    public void addMessageSelectorFactory(MessageSelectorFactory<?> factory) {
        if (factory instanceof BeanFactoryAware) {
            ((BeanFactoryAware)factory).setBeanFactory(this.beanFactory);
        }
        this.factories.add(factory);
    }
}

