/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.channel.selector;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.validation.matcher.ValidationMatcherUtils;
import org.springframework.integration.core.MessageSelector;
import org.springframework.messaging.Message;

public abstract class AbstractMessageSelector
implements MessageSelector {
    protected final String selectKey;
    protected final String matchingValue;
    protected final TestContext context;

    public AbstractMessageSelector(String selectKey, String matchingValue, TestContext context) {
        this.selectKey = selectKey;
        this.matchingValue = matchingValue;
        this.context = context;
    }

    String getPayloadAsString(Message<?> message) {
        if (message.getPayload() instanceof com.consol.citrus.message.Message) {
            return ((com.consol.citrus.message.Message)message.getPayload()).getPayload(String.class);
        }
        return message.getPayload().toString();
    }

    protected boolean evaluate(String value) {
        if (ValidationMatcherUtils.isValidationMatcherExpression(this.matchingValue)) {
            try {
                ValidationMatcherUtils.resolveValidationMatcher(this.selectKey, value, this.matchingValue, this.context);
                return true;
            }
            catch (ValidationException e) {
                return false;
            }
        }
        return value.equals(this.matchingValue);
    }
}

