/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.channel;

import com.consol.citrus.channel.ChannelProducer;
import com.consol.citrus.channel.ChannelSyncEndpointConfiguration;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.ActionTimeoutException;
import com.consol.citrus.message.correlation.CorrelationManager;
import com.consol.citrus.message.correlation.PollingCorrelationManager;
import com.consol.citrus.messaging.ReplyConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;

public class ChannelSyncProducer
extends ChannelProducer
implements ReplyConsumer {
    private static Logger log = LoggerFactory.getLogger(ChannelSyncProducer.class);
    private CorrelationManager<com.consol.citrus.message.Message> correlationManager;
    private final ChannelSyncEndpointConfiguration endpointConfiguration;

    public ChannelSyncProducer(String name, ChannelSyncEndpointConfiguration endpointConfiguration) {
        super(name, endpointConfiguration);
        this.endpointConfiguration = endpointConfiguration;
        this.correlationManager = new PollingCorrelationManager<com.consol.citrus.message.Message>(endpointConfiguration, "Reply message did not arrive yet");
    }

    @Override
    public void send(com.consol.citrus.message.Message message, TestContext context) {
        String correlationKeyName = this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName());
        String correlationKey = this.endpointConfiguration.getCorrelator().getCorrelationKey(message);
        this.correlationManager.saveCorrelationKey(correlationKeyName, correlationKey, context);
        String destinationChannelName = this.getDestinationChannelName();
        if (log.isDebugEnabled()) {
            log.debug("Sending message to channel: '" + destinationChannelName + "'");
            log.debug("Message to send is:\n" + message.toString());
        }
        this.endpointConfiguration.getMessagingTemplate().setReceiveTimeout(this.endpointConfiguration.getTimeout());
        log.info("Message was sent to channel: '" + destinationChannelName + "'");
        Message replyMessage = this.endpointConfiguration.getMessagingTemplate().sendAndReceive(this.getDestinationChannel(context), this.endpointConfiguration.getMessageConverter().convertOutbound(message, this.endpointConfiguration, context));
        if (replyMessage == null) {
            throw new ActionTimeoutException("Reply timed out after " + this.endpointConfiguration.getTimeout() + "ms. Did not receive reply message on reply channel");
        }
        log.info("Received synchronous response from reply channel");
        this.correlationManager.store(correlationKey, this.endpointConfiguration.getMessageConverter().convertInbound(replyMessage, this.endpointConfiguration, context));
    }

    @Override
    public com.consol.citrus.message.Message receive(TestContext context) {
        return this.receive(this.correlationManager.getCorrelationKey(this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName()), context), context);
    }

    @Override
    public com.consol.citrus.message.Message receive(String selector, TestContext context) {
        return this.receive(selector, context, this.endpointConfiguration.getTimeout());
    }

    @Override
    public com.consol.citrus.message.Message receive(TestContext context, long timeout) {
        return this.receive(this.correlationManager.getCorrelationKey(this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName()), context), context, timeout);
    }

    @Override
    public com.consol.citrus.message.Message receive(String selector, TestContext context, long timeout) {
        com.consol.citrus.message.Message message = this.correlationManager.find(selector, timeout);
        if (message == null) {
            throw new ActionTimeoutException("Action timeout while receiving synchronous reply message on message channel");
        }
        return message;
    }

    public CorrelationManager<com.consol.citrus.message.Message> getCorrelationManager() {
        return this.correlationManager;
    }

    public void setCorrelationManager(CorrelationManager<com.consol.citrus.message.Message> correlationManager) {
        this.correlationManager = correlationManager;
    }
}

