/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.channel;

import com.consol.citrus.channel.ChannelEndpoint;
import com.consol.citrus.channel.ChannelSyncEndpoint;
import com.consol.citrus.channel.ChannelSyncEndpointConfiguration;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.AbstractEndpointComponent;
import com.consol.citrus.endpoint.Endpoint;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.messaging.core.DestinationResolver;

public class ChannelEndpointComponent
extends AbstractEndpointComponent {
    @Override
    protected Endpoint createEndpoint(String resourcePath, Map<String, String> parameters, TestContext context) {
        ChannelEndpoint endpoint;
        if (resourcePath.startsWith("sync:")) {
            ChannelSyncEndpointConfiguration endpointConfiguration = new ChannelSyncEndpointConfiguration();
            endpoint = new ChannelSyncEndpoint(endpointConfiguration);
            endpoint.getEndpointConfiguration().setChannelName(resourcePath.substring("sync:".length()));
        } else {
            endpoint = new ChannelEndpoint();
            endpoint.getEndpointConfiguration().setChannelName(resourcePath);
        }
        if (context.getApplicationContext() != null) {
            endpoint.getEndpointConfiguration().setBeanFactory((BeanFactory)context.getApplicationContext());
            endpoint.getEndpointConfiguration().setChannelResolver((DestinationResolver)new BeanFactoryChannelResolver((BeanFactory)context.getApplicationContext()));
        }
        this.enrichEndpointConfiguration(endpoint.getEndpointConfiguration(), parameters, context);
        return endpoint;
    }
}

