/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.annotations;

import com.consol.citrus.Citrus;
import com.consol.citrus.annotations.CitrusEndpoint;
import com.consol.citrus.annotations.CitrusEndpointConfig;
import com.consol.citrus.annotations.CitrusFramework;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.Endpoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class CitrusAnnotations {
    private static Logger log = LoggerFactory.getLogger(CitrusAnnotations.class);

    private CitrusAnnotations() {
    }

    public static final void injectAll(Object target) {
        CitrusAnnotations.injectAll(target, Citrus.newInstance());
    }

    public static final void injectAll(Object target, Citrus citrusFramework) {
        CitrusAnnotations.injectAll(target, citrusFramework, citrusFramework.createTestContext());
    }

    public static final void injectAll(Object target, Citrus citrusFramework, TestContext context) {
        CitrusAnnotations.injectCitrusFramework(target, citrusFramework);
        CitrusAnnotations.injectEndpoints(target, context);
    }

    public static final void injectEndpoints(final Object target, final TestContext context) {
        ReflectionUtils.doWithFields(target.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                log.debug(String.format("Injecting Citrus endpoint on test class field '%s'", field.getName()));
                CitrusEndpoint endpointAnnotation = field.getAnnotation(CitrusEndpoint.class);
                for (Annotation annotation : field.getAnnotations()) {
                    if (annotation.annotationType().getAnnotation(CitrusEndpointConfig.class) == null) continue;
                    ReflectionUtils.setField((Field)field, (Object)target, (Object)context.getEndpointFactory().create(CitrusAnnotations.getEndpointName(field), annotation, context));
                    return;
                }
                Endpoint endpoint = StringUtils.hasText((String)endpointAnnotation.name()) ? (Endpoint)context.getReferenceResolver().resolve(endpointAnnotation.name(), field.getType()) : (Endpoint)context.getReferenceResolver().resolve(field.getType());
                ReflectionUtils.setField((Field)field, (Object)target, (Object)endpoint);
            }
        }, (ReflectionUtils.FieldFilter)new ReflectionUtils.FieldFilter(){

            public boolean matches(Field field) {
                if (field.isAnnotationPresent(CitrusEndpoint.class) && Endpoint.class.isAssignableFrom(field.getType())) {
                    if (!field.isAccessible()) {
                        ReflectionUtils.makeAccessible((Field)field);
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public static final void injectCitrusFramework(final Object testCase, final Citrus citrusFramework) {
        ReflectionUtils.doWithFields(testCase.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                log.debug(String.format("Injecting Citrus framework instance on test class field '%s'", field.getName()));
                ReflectionUtils.setField((Field)field, (Object)testCase, (Object)citrusFramework);
            }
        }, (ReflectionUtils.FieldFilter)new ReflectionUtils.FieldFilter(){

            public boolean matches(Field field) {
                if (field.isAnnotationPresent(CitrusFramework.class) && Citrus.class.isAssignableFrom(field.getType())) {
                    if (!field.isAccessible()) {
                        ReflectionUtils.makeAccessible((Field)field);
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private static String getEndpointName(Field field) {
        if (field.getAnnotation(CitrusEndpoint.class) != null && StringUtils.hasText((String)field.getAnnotation(CitrusEndpoint.class).name())) {
            return field.getAnnotation(CitrusEndpoint.class).name();
        }
        return field.getName();
    }
}

