/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.Citrus;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.FileUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.StringSource;

public class TransformAction
extends AbstractTestAction {
    private String xmlData;
    private String xmlResourcePath;
    private String xmlResourceCharset = Citrus.CITRUS_FILE_ENCODING;
    private String xsltData;
    private String xsltResourcePath;
    private String xsltResourceCharset = Citrus.CITRUS_FILE_ENCODING;
    private String targetVariable = "transform-result";
    private static Logger log = LoggerFactory.getLogger(TransformAction.class);

    public TransformAction() {
        this.setName("transform");
    }

    @Override
    public void doExecute(TestContext context) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Starting XSLT transformation");
            }
            StringSource xmlSource = null;
            if (this.xmlResourcePath != null) {
                xmlSource = new StringSource(context.replaceDynamicContentInString(FileUtils.readToString(FileUtils.getFileResource(this.xmlResourcePath, context), Charset.forName(context.replaceDynamicContentInString(this.xmlResourceCharset)))));
            } else if (this.xmlData != null) {
                xmlSource = new StringSource(context.replaceDynamicContentInString(this.xmlData));
            } else {
                throw new CitrusRuntimeException("Neither inline XML nor external file resource is defined for bean. Cannot transform XML document.");
            }
            StringSource xsltSource = null;
            if (this.xsltResourcePath != null) {
                xsltSource = new StringSource(context.replaceDynamicContentInString(FileUtils.readToString(FileUtils.getFileResource(this.xsltResourcePath, context), Charset.forName(context.replaceDynamicContentInString(this.xsltResourceCharset)))));
            } else if (this.xsltData != null) {
                xsltSource = new StringSource(context.replaceDynamicContentInString(this.xsltData));
            } else {
                throw new CitrusRuntimeException("Neither inline XSLT nor external file resource is defined for bean. Cannot transform XSLT document.");
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer((Source)xsltSource);
            StringResult result = new StringResult();
            transformer.transform((Source)xmlSource, (Result)result);
            context.setVariable(this.targetVariable, result.toString());
            log.info("Finished XSLT transformation");
        }
        catch (IOException | TransformerException e) {
            throw new CitrusRuntimeException(e);
        }
    }

    public TransformAction setXmlData(String xmlData) {
        this.xmlData = xmlData;
        return this;
    }

    public TransformAction setXmlResourcePath(String xmlResource) {
        this.xmlResourcePath = xmlResource;
        return this;
    }

    public TransformAction setXsltData(String xsltData) {
        this.xsltData = xsltData;
        return this;
    }

    public TransformAction setXsltResourcePath(String xsltResource) {
        this.xsltResourcePath = xsltResource;
        return this;
    }

    public TransformAction setTargetVariable(String targetVariable) {
        this.targetVariable = targetVariable;
        return this;
    }

    public String getXmlData() {
        return this.xmlData;
    }

    public String getXmlResourcePath() {
        return this.xmlResourcePath;
    }

    public String getXsltData() {
        return this.xsltData;
    }

    public String getXsltResourcePath() {
        return this.xsltResourcePath;
    }

    public String getTargetVariable() {
        return this.targetVariable;
    }
}

