/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceVariablesAction
extends AbstractTestAction {
    private List<String> variableNames;
    private static Logger log = LoggerFactory.getLogger(TraceVariablesAction.class);

    public TraceVariablesAction() {
        this.setName("trace");
    }

    @Override
    public void doExecute(TestContext context) {
        log.info("Trace variables");
        Iterator<String> it = this.variableNames != null && this.variableNames.size() > 0 ? this.variableNames.iterator() : context.getVariables().keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            String value = context.getVariable(key);
            log.info("Variable " + key + " = " + value);
        }
    }

    public TraceVariablesAction setVariableNames(List<String> variableNames) {
        this.variableNames = variableNames;
        return this;
    }

    public List<String> getVariableNames() {
        return this.variableNames;
    }
}

