/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopTimeAction
extends AbstractTestAction {
    public static final String DEFAULT_TIMELINE_ID = "CITRUS_TIMELINE";
    public static final String DEFAULT_TIMELINE_VALUE_SUFFIX = "_VALUE";
    private String id = "CITRUS_TIMELINE";
    private String suffix = "_VALUE";
    private static Logger log = LoggerFactory.getLogger(StopTimeAction.class);

    public StopTimeAction() {
        this.setName("stop-time");
    }

    @Override
    public void doExecute(TestContext context) {
        String timeLineId = context.replaceDynamicContentInString(this.id);
        String timeLineSuffix = context.replaceDynamicContentInString(this.suffix);
        try {
            if (context.getVariables().containsKey(timeLineId)) {
                long time = System.currentTimeMillis() - context.getVariable(timeLineId, Long.class);
                context.setVariable(timeLineId + timeLineSuffix, time);
                if (this.description != null) {
                    log.info("TimeWatcher " + timeLineId + " after " + time + " ms (" + this.description + ")");
                } else {
                    log.info("TimeWatcher " + timeLineId + " after " + time + " ms");
                }
            } else {
                log.info("Starting TimeWatcher: " + timeLineId);
                context.setVariable(timeLineId, System.currentTimeMillis());
                context.setVariable(timeLineId + timeLineSuffix, 0L);
            }
        }
        catch (Exception e) {
            throw new CitrusRuntimeException(e);
        }
    }

    public StopTimeAction setId(String period) {
        this.id = period;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public StopTimeAction setSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

