/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SleepAction
extends AbstractTestAction {
    private String seconds;
    private String milliseconds = "5000";
    private static Logger log = LoggerFactory.getLogger(SleepAction.class);

    public SleepAction() {
        this.setName("sleep");
    }

    @Override
    public void doExecute(TestContext context) {
        String value = StringUtils.hasText((String)this.seconds) ? String.valueOf((long)(Double.valueOf(context.resolveDynamicValue(this.seconds)) * 1000.0)) : context.resolveDynamicValue(this.milliseconds);
        try {
            log.info(String.format("Sleeping %s ms", value));
            Thread.sleep(Long.valueOf(value));
            log.info(String.format("Returning after %s ms", value));
        }
        catch (InterruptedException e) {
            throw new CitrusRuntimeException(e);
        }
    }

    public SleepAction setMilliseconds(String milliseconds) {
        this.milliseconds = milliseconds;
        return this;
    }

    public String getMilliseconds() {
        return this.milliseconds;
    }

    public SleepAction setSeconds(String seconds) {
        this.seconds = seconds;
        return this;
    }

    public String getSeconds() {
        return this.seconds;
    }
}

