/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.Citrus;
import com.consol.citrus.Completable;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageDirection;
import com.consol.citrus.validation.builder.MessageContentBuilder;
import com.consol.citrus.validation.builder.PayloadTemplateMessageBuilder;
import com.consol.citrus.variable.VariableExtractor;
import com.consol.citrus.variable.dictionary.DataDictionary;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.util.StringUtils;

public class SendMessageAction
extends AbstractTestAction
implements Completable {
    private Endpoint endpoint;
    private String endpointUri;
    private List<VariableExtractor> variableExtractors = new ArrayList<VariableExtractor>();
    private MessageContentBuilder messageBuilder = new PayloadTemplateMessageBuilder();
    private boolean forkMode = false;
    private CompletableFuture<Void> finished;
    private String messageType = Citrus.DEFAULT_MESSAGE_TYPE;
    private DataDictionary dataDictionary;
    private static Logger log = LoggerFactory.getLogger(SendMessageAction.class);

    public SendMessageAction() {
        this.setName("send");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute(TestContext context) {
        Message message = this.createMessage(context, this.messageType);
        this.finished = new CompletableFuture();
        for (VariableExtractor variableExtractor : this.variableExtractors) {
            variableExtractor.extractVariables(message, context);
        }
        Endpoint messageEndpoint = this.getOrCreateEndpoint(context);
        if (StringUtils.hasText((String)message.getName())) {
            context.getMessageStore().storeMessage(message.getName(), message);
        } else {
            context.getMessageStore().storeMessage(context.getMessageStore().constructMessageName(this, messageEndpoint), message);
        }
        if (this.forkMode) {
            log.debug("Forking message sending action ...");
            SimpleAsyncTaskExecutor taskExecutor = new SimpleAsyncTaskExecutor();
            taskExecutor.execute(() -> {
                try {
                    messageEndpoint.createProducer().send(message, context);
                }
                catch (Exception e) {
                    if (e instanceof CitrusRuntimeException) {
                        context.addException((CitrusRuntimeException)e);
                    } else {
                        context.addException(new CitrusRuntimeException(e));
                    }
                }
                finally {
                    this.finished.complete(null);
                }
            });
        } else {
            try {
                messageEndpoint.createProducer().send(message, context);
            }
            finally {
                this.finished.complete(null);
            }
        }
    }

    @Override
    public boolean isDisabled(TestContext context) {
        Endpoint messageEndpoint = this.getOrCreateEndpoint(context);
        if (this.getActor() == null && messageEndpoint.getActor() != null) {
            return messageEndpoint.getActor().isDisabled();
        }
        return super.isDisabled(context);
    }

    @Override
    public boolean isDone(TestContext context) {
        return Optional.ofNullable(this.finished).map(future -> future.isDone() || this.isDisabled(context)).orElse(this.isDisabled(context));
    }

    protected Message createMessage(TestContext context, String messageType) {
        if (this.dataDictionary != null) {
            this.messageBuilder.setDataDictionary(this.dataDictionary);
        }
        return this.messageBuilder.buildMessageContent(context, messageType, MessageDirection.OUTBOUND);
    }

    public Endpoint getOrCreateEndpoint(TestContext context) {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        if (StringUtils.hasText((String)this.endpointUri)) {
            return context.getEndpointFactory().create(this.endpointUri, context);
        }
        throw new CitrusRuntimeException("Neither endpoint nor endpoint uri is set properly!");
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public SendMessageAction setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public SendMessageAction setMessageBuilder(MessageContentBuilder messageBuilder) {
        this.messageBuilder = messageBuilder;
        return this;
    }

    public SendMessageAction setVariableExtractors(List<VariableExtractor> variableExtractors) {
        this.variableExtractors = variableExtractors;
        return this;
    }

    public List<VariableExtractor> getVariableExtractors() {
        return this.variableExtractors;
    }

    public MessageContentBuilder getMessageBuilder() {
        return this.messageBuilder;
    }

    public SendMessageAction setForkMode(boolean fork) {
        this.forkMode = fork;
        return this;
    }

    public boolean isForkMode() {
        return this.forkMode;
    }

    public SendMessageAction setMessageType(String messageType) {
        this.messageType = messageType;
        return this;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public DataDictionary getDataDictionary() {
        return this.dataDictionary;
    }

    public SendMessageAction setDataDictionary(DataDictionary dataDictionary) {
        this.dataDictionary = dataDictionary;
        return this;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public SendMessageAction setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
        return this;
    }
}

