/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.ActionTimeoutException;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageSelectorBuilder;
import com.consol.citrus.messaging.Consumer;
import com.consol.citrus.messaging.SelectiveConsumer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ReceiveTimeoutAction
extends AbstractTestAction {
    private long timeout = 1000L;
    private Endpoint endpoint;
    private String endpointUri;
    private Map<String, Object> messageSelectorMap = new HashMap<String, Object>();
    private String messageSelector;
    private static Logger log = LoggerFactory.getLogger(ReceiveTimeoutAction.class);

    public ReceiveTimeoutAction() {
        this.setName("receive-timeout");
    }

    @Override
    public void doExecute(TestContext context) {
        try {
            Consumer consumer = this.getOrCreateEndpoint(context).createConsumer();
            String selector = MessageSelectorBuilder.build(this.messageSelector, this.messageSelectorMap, context);
            Message receivedMessage = StringUtils.hasText((String)selector) && consumer instanceof SelectiveConsumer ? ((SelectiveConsumer)consumer).receive(selector, context, this.timeout) : consumer.receive(context, this.timeout);
            if (receivedMessage != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Received message: " + receivedMessage.getPayload());
                }
                throw new CitrusRuntimeException("Message timeout validation failed! Received message while waiting for timeout on destination");
            }
        }
        catch (ActionTimeoutException e) {
            log.info("No messages received on destination. Message timeout validation OK!");
            log.info(e.getMessage());
        }
    }

    public Endpoint getOrCreateEndpoint(TestContext context) {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        if (StringUtils.hasText((String)this.endpointUri)) {
            this.endpoint = context.getEndpointFactory().create(this.endpointUri, context);
            return this.endpoint;
        }
        throw new CitrusRuntimeException("Neither endpoint nor endpoint uri is set properly!");
    }

    public ReceiveTimeoutAction setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public ReceiveTimeoutAction setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
        return this;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public ReceiveTimeoutAction setMessageSelectorMap(Map<String, Object> messageSelector) {
        this.messageSelectorMap = messageSelector;
        return this;
    }

    public Map<String, Object> getMessageSelectorMap() {
        return this.messageSelectorMap;
    }

    public ReceiveTimeoutAction setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public ReceiveTimeoutAction setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
        return this;
    }
}

