/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.Citrus;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageDirection;
import com.consol.citrus.message.MessageSelectorBuilder;
import com.consol.citrus.messaging.Consumer;
import com.consol.citrus.messaging.SelectiveConsumer;
import com.consol.citrus.validation.DefaultMessageHeaderValidator;
import com.consol.citrus.validation.MessageValidator;
import com.consol.citrus.validation.builder.MessageContentBuilder;
import com.consol.citrus.validation.builder.PayloadTemplateMessageBuilder;
import com.consol.citrus.validation.callback.ValidationCallback;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.json.JsonPathMessageValidationContext;
import com.consol.citrus.validation.script.ScriptValidationContext;
import com.consol.citrus.validation.xml.XpathMessageValidationContext;
import com.consol.citrus.variable.VariableExtractor;
import com.consol.citrus.variable.dictionary.DataDictionary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ReceiveMessageAction
extends AbstractTestAction {
    private Map<String, Object> messageSelectorMap = new HashMap<String, Object>();
    private String messageSelector;
    private Endpoint endpoint;
    private String endpointUri;
    private long receiveTimeout = 0L;
    private MessageContentBuilder messageBuilder = new PayloadTemplateMessageBuilder();
    private List<MessageValidator<? extends ValidationContext>> validators = new ArrayList<MessageValidator<? extends ValidationContext>>();
    private DataDictionary dataDictionary;
    private ValidationCallback validationCallback;
    private List<ValidationContext> validationContexts = new ArrayList<ValidationContext>();
    private List<VariableExtractor> variableExtractors = new ArrayList<VariableExtractor>();
    private String messageType = Citrus.DEFAULT_MESSAGE_TYPE;
    private static Logger log = LoggerFactory.getLogger(ReceiveMessageAction.class);

    public ReceiveMessageAction() {
        this.setName("receive");
    }

    @Override
    public void doExecute(TestContext context) {
        try {
            String selector = MessageSelectorBuilder.build(this.messageSelector, this.messageSelectorMap, context);
            Message receivedMessage = StringUtils.hasText((String)selector) ? this.receiveSelected(context, selector) : this.receive(context);
            if (receivedMessage == null) {
                throw new CitrusRuntimeException("Failed to receive message - message is not available");
            }
            this.validateMessage(receivedMessage, context);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(e);
        }
    }

    private Message receive(TestContext context) {
        Endpoint messageEndpoint = this.getOrCreateEndpoint(context);
        return this.receiveTimeout > 0L ? messageEndpoint.createConsumer().receive(context, this.receiveTimeout) : messageEndpoint.createConsumer().receive(context, messageEndpoint.getEndpointConfiguration().getTimeout());
    }

    private Message receiveSelected(TestContext context, String selectorString) {
        Endpoint messageEndpoint;
        Consumer consumer;
        if (log.isDebugEnabled()) {
            log.debug("Setting message selector: '" + selectorString + "'");
        }
        if ((consumer = (messageEndpoint = this.getOrCreateEndpoint(context)).createConsumer()) instanceof SelectiveConsumer) {
            if (this.receiveTimeout > 0L) {
                return ((SelectiveConsumer)messageEndpoint.createConsumer()).receive(context.replaceDynamicContentInString(selectorString), context, this.receiveTimeout);
            }
            return ((SelectiveConsumer)messageEndpoint.createConsumer()).receive(context.replaceDynamicContentInString(selectorString), context, messageEndpoint.getEndpointConfiguration().getTimeout());
        }
        log.warn(String.format("Unable to receive selective with consumer implementation: '%s'", consumer.getClass()));
        return this.receive(context);
    }

    protected void validateMessage(Message receivedMessage, TestContext context) throws IOException {
        for (VariableExtractor variableExtractor : this.variableExtractors) {
            variableExtractor.extractVariables(receivedMessage, context);
        }
        if (this.validationCallback != null) {
            if (StringUtils.hasText((String)receivedMessage.getName())) {
                context.getMessageStore().storeMessage(receivedMessage.getName(), receivedMessage);
            } else {
                context.getMessageStore().storeMessage(context.getMessageStore().constructMessageName(this, this.getOrCreateEndpoint(context)), receivedMessage);
            }
            this.validationCallback.validate(receivedMessage, context);
        } else {
            Message controlMessage = this.createControlMessage(context, this.messageType);
            if (StringUtils.hasText((String)controlMessage.getName())) {
                context.getMessageStore().storeMessage(controlMessage.getName(), receivedMessage);
            } else {
                context.getMessageStore().storeMessage(context.getMessageStore().constructMessageName(this, this.getOrCreateEndpoint(context)), receivedMessage);
            }
            if (!CollectionUtils.isEmpty(this.validators)) {
                MessageValidator messageValidator;
                for (MessageValidator<? extends ValidationContext> messageValidator2 : this.validators) {
                    messageValidator2.validateMessage(receivedMessage, controlMessage, context, this.validationContexts);
                }
                if (this.validators.parallelStream().map(Object::getClass).noneMatch(DefaultMessageHeaderValidator.class::isAssignableFrom) && (messageValidator = context.getMessageValidatorRegistry().getDefaultMessageHeaderValidator()) != null) {
                    messageValidator.validateMessage(receivedMessage, controlMessage, context, this.validationContexts);
                }
            } else {
                List<MessageValidator<? extends ValidationContext>> list = context.getMessageValidatorRegistry().findMessageValidators(this.messageType, receivedMessage);
                if (list.isEmpty()) {
                    if (controlMessage.getPayload() instanceof String && StringUtils.hasText((String)controlMessage.getPayload(String.class))) {
                        throw new CitrusRuntimeException(String.format("Unable to find proper message validator for message type '%s' and validation contexts '%s'", this.messageType, this.validationContexts));
                    }
                    if (this.validationContexts.stream().anyMatch(item -> JsonPathMessageValidationContext.class.isAssignableFrom(item.getClass()) || XpathMessageValidationContext.class.isAssignableFrom(item.getClass()) || ScriptValidationContext.class.isAssignableFrom(item.getClass()))) {
                        throw new CitrusRuntimeException(String.format("Unable to find proper message validator for message type '%s' and validation contexts '%s'", this.messageType, this.validationContexts));
                    }
                    log.warn(String.format("Unable to find proper message validator for message type '%s' and validation contexts '%s'", this.messageType, this.validationContexts));
                }
                for (MessageValidator<? extends ValidationContext> messageValidator : list) {
                    messageValidator.validateMessage(receivedMessage, controlMessage, context, this.validationContexts);
                }
            }
        }
    }

    protected Message createControlMessage(TestContext context, String messageType) {
        if (this.dataDictionary != null) {
            this.messageBuilder.setDataDictionary(this.dataDictionary);
        }
        return this.messageBuilder.buildMessageContent(context, messageType, MessageDirection.INBOUND);
    }

    @Override
    public boolean isDisabled(TestContext context) {
        Endpoint messageEndpoint = this.getOrCreateEndpoint(context);
        if (this.getActor() == null && messageEndpoint.getActor() != null) {
            return messageEndpoint.getActor().isDisabled();
        }
        return super.isDisabled(context);
    }

    public ReceiveMessageAction setMessageSelectorMap(Map<String, Object> messageSelectorMap) {
        this.messageSelectorMap = messageSelectorMap;
        return this;
    }

    public ReceiveMessageAction setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
        return this;
    }

    public ReceiveMessageAction setValidators(List<MessageValidator<? extends ValidationContext>> validators) {
        this.validators.clear();
        this.validators.addAll(validators);
        return this;
    }

    public ReceiveMessageAction addValidator(MessageValidator<? extends ValidationContext> validator) {
        this.validators.add(validator);
        return this;
    }

    public Endpoint getOrCreateEndpoint(TestContext context) {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        if (StringUtils.hasText((String)this.endpointUri)) {
            return context.getEndpointFactory().create(this.endpointUri, context);
        }
        throw new CitrusRuntimeException("Neither endpoint nor endpoint uri is set properly!");
    }

    public ReceiveMessageAction setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public ReceiveMessageAction setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
        return this;
    }

    public ReceiveMessageAction setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
        return this;
    }

    public ReceiveMessageAction addVariableExtractors(VariableExtractor variableExtractor) {
        this.variableExtractors.add(variableExtractor);
        return this;
    }

    public ReceiveMessageAction setVariableExtractors(List<VariableExtractor> variableExtractors) {
        this.variableExtractors = variableExtractors;
        return this;
    }

    public ReceiveMessageAction setValidationContexts(List<ValidationContext> validationContexts) {
        this.validationContexts = validationContexts;
        return this;
    }

    public List<VariableExtractor> getVariableExtractors() {
        return this.variableExtractors;
    }

    public ReceiveMessageAction setMessageType(String messageType) {
        this.messageType = messageType;
        return this;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public Map<String, Object> getMessageSelectorMap() {
        return this.messageSelectorMap;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public List<MessageValidator<? extends ValidationContext>> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }

    public List<ValidationContext> getValidationContexts() {
        return this.validationContexts;
    }

    public ValidationCallback getValidationCallback() {
        return this.validationCallback;
    }

    public ReceiveMessageAction setValidationCallback(ValidationCallback validationCallback) {
        this.validationCallback = validationCallback;
        return this;
    }

    public DataDictionary getDataDictionary() {
        return this.dataDictionary;
    }

    public ReceiveMessageAction setDataDictionary(DataDictionary dataDictionary) {
        this.dataDictionary = dataDictionary;
        return this;
    }

    public MessageContentBuilder getMessageBuilder() {
        return this.messageBuilder;
    }

    public ReceiveMessageAction setMessageBuilder(MessageContentBuilder messageBuilder) {
        this.messageBuilder = messageBuilder;
        return this;
    }
}

