/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.DestinationResolver;

public class PurgeMessageChannelAction
extends AbstractTestAction
implements InitializingBean,
BeanFactoryAware {
    private List<String> channelNames = new ArrayList<String>();
    private List<MessageChannel> channels = new ArrayList<MessageChannel>();
    private BeanFactory beanFactory;
    private DestinationResolver<MessageChannel> channelResolver;
    private MessageSelector messageSelector;
    private static Logger log = LoggerFactory.getLogger(PurgeMessageChannelAction.class);

    public PurgeMessageChannelAction() {
        this.setName("purge-channel");
    }

    @Override
    public void doExecute(TestContext context) {
        if (log.isDebugEnabled()) {
            log.debug("Purging message channels ...");
        }
        for (MessageChannel channel : this.channels) {
            this.purgeChannel(channel);
        }
        for (String channelName : this.channelNames) {
            this.purgeChannel(this.resolveChannelName(channelName));
        }
        log.info("Purged message channels");
    }

    private void purgeChannel(MessageChannel channel) {
        if (channel instanceof QueueChannel) {
            List messages = ((QueueChannel)channel).purge(this.messageSelector);
            if (log.isDebugEnabled()) {
                log.debug("Purged channel " + ((QueueChannel)channel).getComponentName() + " - removed " + messages.size() + " messages");
            }
        }
    }

    protected MessageChannel resolveChannelName(String channelName) {
        if (this.channelResolver == null) {
            this.channelResolver = new BeanFactoryChannelResolver(this.beanFactory);
        }
        return (MessageChannel)this.channelResolver.resolveDestination(channelName);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.messageSelector == null) {
            this.messageSelector = new AllAcceptingMessageSelector();
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public List<String> getChannelNames() {
        return this.channelNames;
    }

    public PurgeMessageChannelAction setChannelNames(List<String> channelNames) {
        this.channelNames = channelNames;
        return this;
    }

    public List<MessageChannel> getChannels() {
        return this.channels;
    }

    public PurgeMessageChannelAction setChannels(List<MessageChannel> channels) {
        this.channels = channels;
        return this;
    }

    public MessageSelector getMessageSelector() {
        return this.messageSelector;
    }

    public PurgeMessageChannelAction setMessageSelector(MessageSelector messageSelector) {
        this.messageSelector = messageSelector;
        return this;
    }

    public DestinationResolver<MessageChannel> getChannelResolver() {
        return this.channelResolver;
    }

    public PurgeMessageChannelAction setChannelResolver(DestinationResolver<MessageChannel> channelResolver) {
        this.channelResolver = channelResolver;
        return this;
    }

    private static final class AllAcceptingMessageSelector
    implements MessageSelector {
        private AllAcceptingMessageSelector() {
        }

        public boolean accept(Message<?> message) {
            return false;
        }
    }
}

