/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.ActionTimeoutException;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageSelectorBuilder;
import com.consol.citrus.messaging.Consumer;
import com.consol.citrus.messaging.SelectiveConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.util.StringUtils;

public class PurgeEndpointAction
extends AbstractTestAction
implements BeanFactoryAware {
    private List<String> endpointNames = new ArrayList<String>();
    private List<Endpoint> endpoints = new ArrayList<Endpoint>();
    private BeanFactory beanFactory;
    private Map<String, Object> messageSelectorMap = new HashMap<String, Object>();
    private String messageSelector;
    private long receiveTimeout = 100L;
    private long sleepTime = 350L;
    private static Logger log = LoggerFactory.getLogger(PurgeEndpointAction.class);

    public PurgeEndpointAction() {
        this.setName("purge-endpoint");
    }

    @Override
    public void doExecute(TestContext context) {
        if (log.isDebugEnabled()) {
            log.debug("Purging message endpoints ...");
        }
        for (Endpoint endpoint : this.endpoints) {
            this.purgeEndpoint(endpoint, context);
        }
        for (String endpointName : this.endpointNames) {
            this.purgeEndpoint(this.resolveEndpointName(endpointName), context);
        }
        log.info("Purged message endpoints");
    }

    private void purgeEndpoint(Endpoint endpoint, TestContext context) {
        Message message;
        if (log.isDebugEnabled()) {
            log.debug("Try to purge message endpoint " + endpoint.getName());
        }
        int messagesPurged = 0;
        Consumer messageConsumer = endpoint.createConsumer();
        do {
            try {
                String selector = MessageSelectorBuilder.build(this.messageSelector, this.messageSelectorMap, context);
                message = StringUtils.hasText((String)selector) && messageConsumer instanceof SelectiveConsumer ? (this.receiveTimeout >= 0L ? ((SelectiveConsumer)messageConsumer).receive(selector, context, this.receiveTimeout) : ((SelectiveConsumer)messageConsumer).receive(selector, context)) : (this.receiveTimeout >= 0L ? messageConsumer.receive(context, this.receiveTimeout) : messageConsumer.receive(context));
            }
            catch (ActionTimeoutException e) {
                if (!log.isDebugEnabled()) break;
                log.debug("Stop purging due to timeout - " + e.getMessage());
                break;
            }
            if (message == null) continue;
            log.debug("Removed message from endpoint " + endpoint.getName());
            ++messagesPurged;
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted during wait", (Throwable)e);
            }
        } while (message != null);
        if (log.isDebugEnabled()) {
            log.debug("Purged " + messagesPurged + " messages from endpoint");
        }
    }

    protected Endpoint resolveEndpointName(String endpointName) {
        try {
            return (Endpoint)this.beanFactory.getBean(endpointName, Endpoint.class);
        }
        catch (BeansException e) {
            throw new CitrusRuntimeException(String.format("Unable to resolve endpoint for name '%s'", endpointName), e);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public List<String> getEndpointNames() {
        return this.endpointNames;
    }

    public PurgeEndpointAction setEndpointNames(List<String> endpointNames) {
        this.endpointNames = endpointNames;
        return this;
    }

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public PurgeEndpointAction setEndpoints(List<Endpoint> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public PurgeEndpointAction setMessageSelectorMap(Map<String, Object> messageSelectorMap) {
        this.messageSelectorMap = messageSelectorMap;
        return this;
    }

    public PurgeEndpointAction setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
        return this;
    }

    public Map<String, Object> getMessageSelectorMap() {
        return this.messageSelectorMap;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public PurgeEndpointAction setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
        return this;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }
}

