/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.FileUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class LoadPropertiesAction
extends AbstractTestAction {
    private String filePath = null;
    private static Logger log = LoggerFactory.getLogger(LoadPropertiesAction.class);

    public LoadPropertiesAction() {
        this.setName("load");
    }

    @Override
    public void doExecute(TestContext context) {
        Properties props;
        Resource resource = FileUtils.getFileResource(this.filePath, context);
        if (log.isDebugEnabled()) {
            log.debug("Reading property file " + resource.getFilename());
        }
        try {
            props = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(e);
        }
        Iterator<Map.Entry<Object, Object>> iter = props.entrySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().getKey().toString();
            if (log.isDebugEnabled()) {
                log.debug("Loading property: " + key + "=" + props.getProperty(key) + " into variables");
            }
            if (log.isDebugEnabled() && context.getVariables().containsKey(key)) {
                log.debug("Overwriting property " + key + " old value:" + context.getVariable(key) + " new value:" + props.getProperty(key));
            }
            context.setVariable(key, context.replaceDynamicContentInString(props.getProperty(key)));
        }
        log.info("Loaded property file " + resource.getFilename());
    }

    public LoadPropertiesAction setFilePath(String file) {
        this.filePath = file;
        return this;
    }

    public String getFilePath() {
        return this.filePath;
    }
}

