/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class JavaAction
extends AbstractTestAction {
    private Object instance;
    private String className;
    private String methodName;
    private List<Object> methodArgs = new ArrayList<Object>();
    private List<Object> constructorArgs = new ArrayList<Object>();
    private static Logger log = LoggerFactory.getLogger(JavaAction.class);

    public JavaAction() {
        this.setName("java");
    }

    @Override
    public void doExecute(TestContext context) {
        try {
            if (this.instance == null) {
                this.instance = this.getObjectInstanceFromClass(context);
            }
            Class[] methodTypes = new Class[this.methodArgs.size()];
            Object[] methodObjects = new Object[this.methodArgs.size()];
            for (int i = 0; i < this.methodArgs.size(); ++i) {
                methodTypes[i] = this.methodArgs.get(i).getClass();
                if (this.methodArgs.get(i).getClass().equals(List.class)) {
                    String[] converted = StringUtils.toStringArray((Collection)((List)this.methodArgs.get(i)));
                    for (int j = 0; j < converted.length; ++j) {
                        converted[j] = context.replaceDynamicContentInString(converted[j]);
                    }
                    methodObjects[i] = converted;
                    continue;
                }
                if (this.methodArgs.get(i).getClass().equals(String[].class)) {
                    String[] params = (String[])this.methodArgs.get(i);
                    String[] converted = Arrays.copyOf(params, params.length);
                    for (int j = 0; j < converted.length; ++j) {
                        converted[j] = context.replaceDynamicContentInString(converted[j]);
                    }
                    methodObjects[i] = converted;
                    continue;
                }
                methodObjects[i] = this.methodArgs.get(i).getClass().equals(String.class) ? context.replaceDynamicContentInString(this.methodArgs.get(i).toString()) : this.methodArgs.get(i);
            }
            this.invokeMethod(methodTypes, methodObjects);
        }
        catch (RuntimeException e) {
            throw new CitrusRuntimeException("Failed to invoke Java method due to runtime error", e);
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to invoke Java method", e);
        }
    }

    private void invokeMethod(Class<?>[] methodTypes, Object[] methodObjects) throws IllegalArgumentException, InvocationTargetException, IllegalAccessException, CitrusRuntimeException {
        Method methodToRun = ReflectionUtils.findMethod(this.instance.getClass(), (String)this.methodName, (Class[])methodTypes);
        if (methodToRun == null) {
            throw new CitrusRuntimeException("Unable to find method '" + this.methodName + "(" + StringUtils.arrayToCommaDelimitedString((Object[])methodTypes) + ")' for class '" + this.instance.getClass() + "'");
        }
        log.info("Invoking method '" + methodToRun.toString() + "' on instance '" + this.instance.getClass() + "'");
        methodToRun.invoke(this.instance, methodObjects);
    }

    private Object getObjectInstanceFromClass(TestContext context) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (!StringUtils.hasText((String)this.className)) {
            throw new CitrusRuntimeException("Neither class name nor object instance reference is set for Java reflection call");
        }
        log.info("Instantiating class for name '" + this.className + "'");
        Class<?> classToRun = Class.forName(this.className);
        Class[] constructorTypes = new Class[this.constructorArgs.size()];
        Object[] constructorObjects = new Object[this.constructorArgs.size()];
        for (int i = 0; i < this.constructorArgs.size(); ++i) {
            constructorTypes[i] = this.constructorArgs.get(i).getClass();
            constructorObjects[i] = this.constructorArgs.get(i).getClass().equals(String.class) ? context.replaceDynamicContentInString(this.constructorArgs.get(i).toString()) : this.constructorArgs.get(i);
        }
        Constructor<?> constr = classToRun.getConstructor(constructorTypes);
        return constr.newInstance(constructorObjects);
    }

    public JavaAction setClassName(String className) {
        this.className = className;
        return this;
    }

    public JavaAction setConstructorArgs(List<Object> constructorArgs) {
        this.constructorArgs = constructorArgs;
        return this;
    }

    public JavaAction setMethodArgs(List<Object> methodArgs) {
        this.methodArgs = methodArgs;
        return this;
    }

    public JavaAction setMethodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public JavaAction setInstance(Object instance) {
        this.instance = instance;
        return this;
    }

    public Object getInstance() {
        return this.instance;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<Object> getMethodArgs() {
        return this.methodArgs;
    }

    public List<Object> getConstructorArgs() {
        return this.constructorArgs;
    }
}

