/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class InputAction
extends AbstractTestAction {
    private static Logger log = LoggerFactory.getLogger(InputAction.class);
    private String message = "Press return key to continue ...";
    private String variable = "userinput";
    private String validAnswers;
    public static final String ANSWER_SEPARATOR = "/";

    public InputAction() {
        this.setName("input");
    }

    @Override
    public void doExecute(TestContext context) {
        String input = null;
        if (context.getVariables().containsKey(this.variable)) {
            input = context.getVariable(this.variable);
            log.info("Variable " + this.variable + " is already set (='" + input + "'). Skip waiting for user input");
            return;
        }
        String display = StringUtils.hasText((String)this.validAnswers) ? this.message + " (" + this.validAnswers + ")" : this.message;
        try {
            do {
                log.info(display);
                BufferedReader stdin = this.getInputReader();
                input = stdin.readLine();
            } while (this.validAnswers != null && !this.checkAnswer(input));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(e);
        }
        context.setVariable(this.variable, input.trim());
    }

    protected BufferedReader getInputReader() {
        return new BufferedReader(new InputStreamReader(System.in));
    }

    private boolean checkAnswer(String input) {
        StringTokenizer tok = new StringTokenizer(this.validAnswers, ANSWER_SEPARATOR);
        while (tok.hasMoreTokens()) {
            if (!tok.nextElement().toString().trim().equalsIgnoreCase(input.trim())) continue;
            return true;
        }
        log.info("User input is not valid - must be one of " + this.validAnswers);
        return false;
    }

    public InputAction setMessage(String message) {
        this.message = message;
        return this;
    }

    public InputAction setVariable(String variable) {
        this.variable = variable;
        return this;
    }

    public InputAction setValidAnswers(String validAnswers) {
        this.validAnswers = validAnswers;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public String getVariable() {
        return this.variable;
    }

    public String getValidAnswers() {
        return this.validAnswers;
    }
}

