/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.actions.AbstractDatabaseConnectingTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.UnknownElementException;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.validation.matcher.ValidationMatcherUtils;
import com.consol.citrus.validation.script.ScriptValidationContext;
import com.consol.citrus.validation.script.sql.GroovySqlResultSetValidator;
import com.consol.citrus.validation.script.sql.SqlResultSetScriptValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;

public class ExecuteSQLQueryAction
extends AbstractDatabaseConnectingTestAction {
    protected Map<String, List<String>> controlResultSet = new HashMap<String, List<String>>();
    private Map<String, String> extractVariables = new HashMap<String, String>();
    private ScriptValidationContext scriptValidationContext;
    @Autowired(required=false)
    private SqlResultSetScriptValidator validator;
    private static final String NULL_VALUE = "NULL";
    private static Logger log = LoggerFactory.getLogger(ExecuteSQLQueryAction.class);

    public ExecuteSQLQueryAction() {
        this.setName("sql-query");
    }

    @Override
    public void doExecute(TestContext context) {
        if (this.statements.isEmpty()) {
            this.statements = this.createStatementsFromFileResource(context);
        }
        try {
            HashMap<String, List<String>> columnValuesMap = new HashMap<String, List<String>>();
            ArrayList<Map<String, Object>> allResultRows = new ArrayList<Map<String, Object>>();
            if (this.getTransactionManager() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Using transaction manager: " + this.getTransactionManager().getClass().getName());
                }
                TransactionTemplate transactionTemplate = new TransactionTemplate(this.getTransactionManager());
                transactionTemplate.setTimeout(Integer.valueOf(context.replaceDynamicContentInString(this.getTransactionTimeout())).intValue());
                transactionTemplate.setIsolationLevelName(context.replaceDynamicContentInString(this.getTransactionIsolationLevel()));
                transactionTemplate.execute(status -> {
                    this.executeStatements(allResultRows, columnValuesMap, context);
                    return null;
                });
            } else {
                this.executeStatements(allResultRows, columnValuesMap, context);
            }
            this.performValidation(columnValuesMap, allResultRows, context);
            this.fillContextVariables(columnValuesMap, context);
            for (Map.Entry column : columnValuesMap.entrySet()) {
                List columnValues = (List)column.getValue();
                context.setVariable(((String)column.getKey()).toUpperCase(), columnValues.get(0) == null ? NULL_VALUE : columnValues.get(0));
            }
        }
        catch (DataAccessException e) {
            log.error("Failed to execute SQL statement", (Throwable)e);
            throw new CitrusRuntimeException(e);
        }
    }

    protected void executeStatements(List<Map<String, Object>> allResultRows, Map<String, List<String>> columnValuesMap, TestContext context) {
        for (String stmt : this.statements) {
            this.validateSqlStatement(stmt);
            String toExecute = stmt.trim().endsWith(";") ? context.replaceDynamicContentInString(stmt.trim().substring(0, stmt.trim().length() - 1)) : context.replaceDynamicContentInString(stmt.trim());
            if (log.isDebugEnabled()) {
                log.debug("Executing SQL query: " + toExecute);
            }
            List results = this.getJdbcTemplate().queryForList(toExecute);
            log.info("SQL query execution successful");
            allResultRows.addAll(results);
            this.fillColumnValuesMap(results, columnValuesMap);
        }
    }

    private void fillContextVariables(Map<String, List<String>> columnValuesMap, TestContext context) throws CitrusRuntimeException {
        for (Map.Entry<String, String> variableEntry : this.extractVariables.entrySet()) {
            String columnName = variableEntry.getKey();
            if (columnValuesMap.containsKey(columnName.toLowerCase())) {
                context.setVariable(variableEntry.getValue(), this.constructVariableValue(columnValuesMap.get(columnName.toLowerCase())));
                continue;
            }
            if (columnValuesMap.containsKey(columnName.toUpperCase())) {
                context.setVariable(variableEntry.getValue(), this.constructVariableValue(columnValuesMap.get(columnName.toUpperCase())));
                continue;
            }
            throw new CitrusRuntimeException("Failed to create variables from database values! Unable to find column '" + columnName + "' in database result set");
        }
    }

    private void fillColumnValuesMap(List<Map<String, Object>> results, Map<String, List<String>> columnValuesMap) {
        for (Map<String, Object> row : results) {
            for (Map.Entry<String, Object> column : row.entrySet()) {
                String columnName = column.getKey();
                if (!columnValuesMap.containsKey(columnName)) {
                    columnValuesMap.put(columnName, new ArrayList());
                }
                String columnValue = column.getValue() instanceof byte[] ? Base64.encodeBase64String((byte[])((byte[])column.getValue())) : (column.getValue() == null ? null : column.getValue().toString());
                columnValuesMap.get(columnName).add(columnValue);
            }
        }
    }

    private SqlResultSetScriptValidator getScriptValidator() {
        if (this.validator != null) {
            return this.validator;
        }
        return new GroovySqlResultSetValidator();
    }

    private String constructVariableValue(List<String> rowValues) {
        if (CollectionUtils.isEmpty(rowValues)) {
            return "";
        }
        if (rowValues.size() == 1) {
            return rowValues.get(0) == null ? NULL_VALUE : rowValues.get(0);
        }
        StringBuilder result = new StringBuilder();
        Iterator<String> it = rowValues.iterator();
        result.append(it.next());
        while (it.hasNext()) {
            String nextValue = it.next();
            result.append(";" + (nextValue == null ? NULL_VALUE : nextValue));
        }
        return result.toString();
    }

    private void performValidation(Map<String, List<String>> columnValuesMap, List<Map<String, Object>> allResultRows, TestContext context) throws UnknownElementException, ValidationException {
        if (this.scriptValidationContext != null) {
            this.getScriptValidator().validateSqlResultSet(allResultRows, this.scriptValidationContext, context);
        }
        if (CollectionUtils.isEmpty(this.controlResultSet)) {
            return;
        }
        this.performControlResultSetValidation(columnValuesMap, context);
        log.info("SQL query validation successful: All values OK");
    }

    private void performControlResultSetValidation(Map<String, List<String>> columnValuesMap, TestContext context) throws CitrusRuntimeException {
        for (Map.Entry<String, List<String>> controlEntry : this.controlResultSet.entrySet()) {
            String columnName = controlEntry.getKey();
            if (columnValuesMap.containsKey(columnName.toLowerCase())) {
                columnName = columnName.toLowerCase();
            } else if (columnValuesMap.containsKey(columnName.toUpperCase())) {
                columnName = columnName.toUpperCase();
            } else if (!columnValuesMap.containsKey(columnName)) {
                throw new CitrusRuntimeException("Could not find column '" + columnName + "' in SQL result set");
            }
            List<String> resultColumnValues = columnValuesMap.get(columnName);
            List<String> controlColumnValues = controlEntry.getValue();
            if (resultColumnValues.size() != controlColumnValues.size()) {
                throw new CitrusRuntimeException("Validation failed for column: '" + columnName + "' expected rows count: " + controlColumnValues.size() + " but was " + resultColumnValues.size());
            }
            Iterator<String> it = resultColumnValues.iterator();
            for (String controlValue : controlColumnValues) {
                String resultValue = it.next();
                controlValue = context.replaceDynamicContentInString(controlValue);
                this.validateSingleValue(columnName, controlValue, resultValue, context);
            }
        }
    }

    protected void validateSqlStatement(String stmt) {
        if (!stmt.toLowerCase().startsWith("select")) {
            throw new CitrusRuntimeException("Missing keyword SELECT in statement: " + stmt);
        }
    }

    protected void validateSingleValue(String columnName, String controlValue, String resultValue, TestContext context) {
        if (controlValue.equals("@ignore@")) {
            if (log.isDebugEnabled()) {
                log.debug("Ignoring column value '" + columnName + "(resultValue)'");
            }
            return;
        }
        if (ValidationMatcherUtils.isValidationMatcherExpression(controlValue)) {
            ValidationMatcherUtils.resolveValidationMatcher(columnName, resultValue, controlValue, context);
            return;
        }
        if (resultValue == null) {
            if (this.isCitrusNullValue(controlValue)) {
                if (log.isDebugEnabled()) {
                    log.debug("Validating database value for column: ''" + columnName + "'' value as expected: NULL - value OK");
                }
                return;
            }
            throw new ValidationException("Validation failed for column: '" + columnName + "'found value: NULL expected value: " + controlValue);
        }
        if (resultValue.equals(controlValue)) {
            if (log.isDebugEnabled()) {
                log.debug("Validation successful for column: '" + columnName + "' expected value: " + controlValue + " - value OK");
            }
        } else {
            throw new ValidationException("Validation failed for column: '" + columnName + "' found value: '" + resultValue + "' expected value: " + (controlValue.length() == 0 ? NULL_VALUE : controlValue));
        }
    }

    private boolean isCitrusNullValue(String controlValue) {
        return controlValue.equalsIgnoreCase(NULL_VALUE) || controlValue.length() == 0;
    }

    public ExecuteSQLQueryAction setControlResultSet(Map<String, List<String>> controlResultSet) {
        this.controlResultSet = controlResultSet;
        return this;
    }

    public ExecuteSQLQueryAction setExtractVariables(Map<String, String> variablesMap) {
        this.extractVariables = variablesMap;
        return this;
    }

    public ExecuteSQLQueryAction setScriptValidationContext(ScriptValidationContext scriptValidationContext) {
        this.scriptValidationContext = scriptValidationContext;
        return this;
    }

    public SqlResultSetScriptValidator getValidator() {
        return this.validator;
    }

    public ExecuteSQLQueryAction setValidator(SqlResultSetScriptValidator validator) {
        this.validator = validator;
        return this;
    }

    public Map<String, List<String>> getControlResultSet() {
        return this.controlResultSet;
    }

    public Map<String, String> getExtractVariables() {
        return this.extractVariables;
    }

    public ScriptValidationContext getScriptValidationContext() {
        return this.scriptValidationContext;
    }
}

