/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.actions.AbstractDatabaseConnectingTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import org.springframework.transaction.support.TransactionTemplate;

public class ExecuteSQLAction
extends AbstractDatabaseConnectingTestAction {
    private boolean ignoreErrors = false;

    public ExecuteSQLAction() {
        this.setName("sql");
    }

    @Override
    public void doExecute(TestContext context) {
        if (this.statements.isEmpty()) {
            this.statements = this.createStatementsFromFileResource(context);
        }
        if (this.getTransactionManager() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Using transaction manager: " + this.getTransactionManager().getClass().getName());
            }
            TransactionTemplate transactionTemplate = new TransactionTemplate(this.getTransactionManager());
            transactionTemplate.setTimeout(Integer.valueOf(context.replaceDynamicContentInString(this.getTransactionTimeout())).intValue());
            transactionTemplate.setIsolationLevelName(context.replaceDynamicContentInString(this.getTransactionIsolationLevel()));
            transactionTemplate.execute(status -> {
                this.executeStatements(context);
                return null;
            });
        } else {
            this.executeStatements(context);
        }
    }

    protected void executeStatements(TestContext context) {
        for (String stmt : this.statements) {
            try {
                String toExecute = stmt.trim().endsWith(";") ? context.replaceDynamicContentInString(stmt.trim().substring(0, stmt.trim().length() - 1)) : context.replaceDynamicContentInString(stmt.trim());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Executing SQL statement: " + toExecute);
                }
                this.getJdbcTemplate().execute(toExecute);
                this.log.info("SQL statement execution successful");
            }
            catch (Exception e) {
                if (this.ignoreErrors) {
                    this.log.error("Ignoring error while executing SQL statement: " + e.getLocalizedMessage());
                    continue;
                }
                throw new CitrusRuntimeException(e);
            }
        }
    }

    public ExecuteSQLAction setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
        return this;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }
}

