/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.actions.AbstractDatabaseConnectingTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.SqlUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StringUtils;

public class ExecutePLSQLAction
extends AbstractDatabaseConnectingTestAction {
    private String script = null;
    private boolean ignoreErrors = false;
    public static final String PLSQL_STMT_ENDING = "/";

    public ExecutePLSQLAction() {
        this.setName("plsql");
    }

    @Override
    public void doExecute(TestContext context) {
        if (StringUtils.hasText((String)this.script)) {
            this.statements = this.createStatementsFromScript(context);
        } else if (StringUtils.hasText((String)this.sqlResourcePath)) {
            this.statements = this.createStatementsFromFileResource(context, new SqlUtils.LastScriptLineDecorator(){

                @Override
                public String getStatementEndingCharacter() {
                    return ExecutePLSQLAction.PLSQL_STMT_ENDING;
                }

                @Override
                public String decorate(String line) {
                    return line.trim().substring(0, line.trim().length() - 1);
                }
            });
        }
        if (this.getTransactionManager() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Using transaction manager: " + this.getTransactionManager().getClass().getName());
            }
            TransactionTemplate transactionTemplate = new TransactionTemplate(this.getTransactionManager());
            transactionTemplate.setTimeout(Integer.valueOf(context.replaceDynamicContentInString(this.getTransactionTimeout())).intValue());
            transactionTemplate.setIsolationLevelName(context.replaceDynamicContentInString(this.getTransactionIsolationLevel()));
            transactionTemplate.execute(status -> {
                this.executeStatements(context);
                return null;
            });
        } else {
            this.executeStatements(context);
        }
    }

    protected void executeStatements(TestContext context) {
        for (String stmt : this.statements) {
            try {
                String toExecute = context.replaceDynamicContentInString(stmt.trim());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Executing PLSQL statement: " + toExecute);
                }
                this.getJdbcTemplate().execute(toExecute);
                this.log.info("PLSQL statement execution successful");
            }
            catch (DataAccessException e) {
                if (this.ignoreErrors) {
                    this.log.warn("Ignoring error while executing PLSQL statement: " + e.getMessage());
                    continue;
                }
                throw new CitrusRuntimeException("Failed to execute PLSQL statement", e);
            }
        }
    }

    private List<String> createStatementsFromScript(TestContext context) {
        ArrayList<String> stmts = new ArrayList<String>();
        this.script = context.replaceDynamicContentInString(this.script);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Found inline PLSQL script " + this.script);
        }
        StringTokenizer tok = new StringTokenizer(this.script, PLSQL_STMT_ENDING);
        while (tok.hasMoreTokens()) {
            String next = tok.nextToken().trim();
            if (!StringUtils.hasText((String)next)) continue;
            stmts.add(next);
        }
        return stmts;
    }

    public ExecutePLSQLAction setScript(String script) {
        this.script = script;
        return this;
    }

    public ExecutePLSQLAction setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
        return this;
    }

    public String getScript() {
        return this.script;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }
}

