/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.variable.VariableUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateVariablesAction
extends AbstractTestAction {
    private Map<String, String> variables = new LinkedHashMap<String, String>();
    private static Logger log = LoggerFactory.getLogger(CreateVariablesAction.class);

    public CreateVariablesAction() {
        this.setName("create-variables");
    }

    @Override
    public void doExecute(TestContext context) {
        for (Map.Entry<String, String> entry : this.variables.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value.startsWith("script:<")) {
                String scriptEngine = value.substring("script:<".length(), value.indexOf(62));
                value = VariableUtils.getValueFromScript(scriptEngine, context.replaceDynamicContentInString(value.substring(value.indexOf(62) + 1)));
            }
            value = context.replaceDynamicContentInString(value);
            log.info("Setting variable: " + key + " to value: " + value);
            context.setVariable(key, value);
        }
    }

    public CreateVariablesAction setVariables(Map<String, String> variables) {
        this.variables = variables;
        return this;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }
}

