/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.StringUtils;

public class AntRunAction
extends AbstractTestAction {
    private String buildFilePath;
    private String target;
    private String targets;
    private Properties properties = new Properties();
    private String propertyFilePath;
    private BuildListener buildListener;
    private static Logger log = LoggerFactory.getLogger(AntRunAction.class);

    public AntRunAction() {
        this.setName("antrun");
    }

    @Override
    public void doExecute(TestContext context) {
        Project project = new Project();
        project.init();
        String buildFileResource = context.replaceDynamicContentInString(this.buildFilePath);
        try {
            ProjectHelper.configureProject((Project)project, (File)new PathMatchingResourcePatternResolver().getResource(buildFileResource).getFile());
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                String propertyValue = entry.getValue() != null ? context.replaceDynamicContentInString(entry.getValue().toString()) : "";
                log.debug("Set build property: " + entry.getKey() + "=" + propertyValue);
                project.setProperty(entry.getKey().toString(), propertyValue);
            }
            this.loadBuildPropertyFile(project, context);
            if (this.buildListener != null) {
                project.addBuildListener(this.buildListener);
            }
            DefaultLogger consoleLogger = new DefaultLogger(){

                protected void printMessage(String message, PrintStream stream, int priority) {
                    if (stream.equals(System.err)) {
                        log.error(message);
                    } else {
                        log.info(message);
                    }
                }
            };
            consoleLogger.setErrorPrintStream(System.err);
            consoleLogger.setOutputPrintStream(System.out);
            consoleLogger.setMessageOutputLevel(4);
            project.addBuildListener((BuildListener)consoleLogger);
            log.info("Executing ANT build: " + buildFileResource);
            if (StringUtils.hasText((String)this.targets)) {
                log.info("Executing ANT targets: " + this.targets);
                project.executeTargets(this.parseTargets());
            } else {
                log.info("Executing ANT target: " + this.target);
                project.executeTarget(this.target);
            }
        }
        catch (BuildException e) {
            throw new CitrusRuntimeException("Failed to run ANT build file", e);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read ANT build file", e);
        }
        log.info("Executed ANT build: " + buildFileResource);
    }

    private Stack<String> parseTargets() {
        String[] targetTokens;
        Stack<String> stack = new Stack<String>();
        for (String targetToken : targetTokens = this.targets.split(",")) {
            stack.add(targetToken.trim());
        }
        return stack;
    }

    private void loadBuildPropertyFile(Project project, TestContext context) {
        if (StringUtils.hasText((String)this.propertyFilePath)) {
            String propertyFileResource = context.replaceDynamicContentInString(this.propertyFilePath);
            log.info("Reading build property file: " + propertyFileResource);
            try {
                Properties fileProperties = PropertiesLoaderUtils.loadProperties((Resource)new PathMatchingResourcePatternResolver().getResource(propertyFileResource));
                for (Map.Entry<Object, Object> entry : fileProperties.entrySet()) {
                    String propertyValue;
                    String string = propertyValue = entry.getValue() != null ? context.replaceDynamicContentInString(entry.getValue().toString()) : "";
                    if (log.isDebugEnabled()) {
                        log.debug("Set build property from file resource: " + entry.getKey() + "=" + propertyValue);
                    }
                    project.setProperty(entry.getKey().toString(), propertyValue);
                }
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read build property file", e);
            }
        }
    }

    public String getBuildFilePath() {
        return this.buildFilePath;
    }

    public AntRunAction setBuildFilePath(String buildFilePath) {
        this.buildFilePath = buildFilePath;
        return this;
    }

    public String getTarget() {
        return this.target;
    }

    public AntRunAction setTarget(String target) {
        this.target = target;
        return this;
    }

    public String getTargets() {
        return this.targets;
    }

    public AntRunAction setTargets(String targets) {
        this.targets = targets;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public AntRunAction setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public String getPropertyFilePath() {
        return this.propertyFilePath;
    }

    public AntRunAction setPropertyFilePath(String propertyFilePath) {
        this.propertyFilePath = propertyFilePath;
        return this;
    }

    public BuildListener getBuildListener() {
        return this.buildListener;
    }

    public AntRunAction setBuildListener(BuildListener buildListener) {
        this.buildListener = buildListener;
        return this;
    }
}

