/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.TestAction;
import com.consol.citrus.TestActor;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.util.SqlUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class AbstractDatabaseConnectingTestAction
extends JdbcDaoSupport
implements TestAction {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private String description;
    private String name = this.getClass().getSimpleName();
    protected String sqlResourcePath;
    protected List<String> statements = new ArrayList<String>();
    private TestActor actor;
    private PlatformTransactionManager transactionManager;
    private String transactionTimeout = String.valueOf(-1);
    private String transactionIsolationLevel = "ISOLATION_DEFAULT";

    @Override
    public void execute(TestContext context) {
        this.doExecute(context);
    }

    public abstract void doExecute(TestContext var1);

    @Override
    public boolean isDisabled(TestContext context) {
        if (this.actor != null) {
            return this.actor.isDisabled();
        }
        return false;
    }

    protected List<String> createStatementsFromFileResource(TestContext context) {
        return SqlUtils.createStatementsFromFileResource(new PathMatchingResourcePatternResolver().getResource(context.replaceDynamicContentInString(this.sqlResourcePath)));
    }

    protected List<String> createStatementsFromFileResource(TestContext context, SqlUtils.LastScriptLineDecorator lineDecorator) {
        return SqlUtils.createStatementsFromFileResource(new PathMatchingResourcePatternResolver().getResource(context.replaceDynamicContentInString(this.sqlResourcePath)), lineDecorator);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public AbstractDatabaseConnectingTestAction setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AbstractDatabaseConnectingTestAction setName(String name) {
        this.name = name;
        return this;
    }

    public AbstractDatabaseConnectingTestAction setStatements(List<String> statements) {
        this.statements = statements;
        return this;
    }

    public AbstractDatabaseConnectingTestAction setSqlResourcePath(String sqlResource) {
        this.sqlResourcePath = sqlResource;
        return this;
    }

    public String getSqlResourcePath() {
        return this.sqlResourcePath;
    }

    public List<String> getStatements() {
        return this.statements;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(String transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public String getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public void setTransactionIsolationLevel(String transactionIsolationLevel) {
        this.transactionIsolationLevel = transactionIsolationLevel;
    }

    @Override
    public TestActor getActor() {
        return this.actor;
    }

    @Override
    public AbstractDatabaseConnectingTestAction setActor(TestActor actor) {
        this.actor = actor;
        return this;
    }
}

