/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.Completable;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.SimpleAsyncTaskExecutor;

public abstract class AbstractAsyncTestAction
extends AbstractTestAction
implements Completable {
    private static Logger log = LoggerFactory.getLogger(AbstractAsyncTestAction.class);
    private Future<?> finished;

    @Override
    public final void doExecute(TestContext context) {
        CompletableFuture result = new CompletableFuture();
        SimpleAsyncTaskExecutor executor = new SimpleAsyncTaskExecutor();
        this.finished = executor.submit(() -> {
            try {
                this.doExecuteAsync(context);
                result.complete(null);
            }
            catch (Exception e) {
                log.warn("Async test action execution raised error", (Throwable)e);
                if (e instanceof CitrusRuntimeException) {
                    context.addException((CitrusRuntimeException)e);
                } else {
                    context.addException(new CitrusRuntimeException(e));
                }
                result.completeExceptionally(e);
            }
        });
        result.whenComplete((nothing, throwable) -> {
            if (throwable != null) {
                this.onError(context, (Throwable)throwable);
            } else {
                this.onSuccess(context);
            }
        });
    }

    @Override
    public boolean isDone(TestContext context) {
        return Optional.ofNullable(this.finished).map(future -> future.isDone() || this.isDisabled(context)).orElse(this.isDisabled(context));
    }

    public abstract void doExecuteAsync(TestContext var1);

    public void onSuccess(TestContext context) {
    }

    public void onError(TestContext context, Throwable error) {
    }
}

