/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus;

import com.consol.citrus.Citrus;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestCaseMetaInfo;
import com.consol.citrus.TestResult;
import com.consol.citrus.container.AbstractActionContainer;
import com.consol.citrus.container.SequenceAfterTest;
import com.consol.citrus.container.SequenceBeforeTest;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.TestCaseFailedException;
import com.consol.citrus.report.TestActionListeners;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class TestCase
extends AbstractActionContainer
implements BeanNameAware {
    private List<TestAction> finalActions = new ArrayList<TestAction>();
    private Map<String, Object> variableDefinitions = new LinkedHashMap<String, Object>();
    private TestCaseMetaInfo metaInfo = new TestCaseMetaInfo();
    private Class<?> testClass = this.getClass();
    private String packageName = this.getClass().getPackage().getName();
    private Map<String, Object> parameters = new LinkedHashMap<String, Object>();
    @Autowired
    private TestActionListeners testActionListeners = new TestActionListeners();
    @Autowired(required=false)
    private List<SequenceBeforeTest> beforeTest;
    @Autowired(required=false)
    private List<SequenceAfterTest> afterTest;
    private TestResult testResult;
    private boolean testRunner = false;
    private String[] groups;
    private long timeout = 10000L;
    private static Logger log = LoggerFactory.getLogger(TestCase.class);

    public void start(TestContext context) {
        context.getTestListeners().onTestStart(this);
        try {
            if (log.isDebugEnabled()) {
                log.debug("Initializing test case");
            }
            if (context.hasVariables() && log.isDebugEnabled()) {
                log.debug("Global variables:");
                for (Map.Entry<String, Object> entry : context.getVariables().entrySet()) {
                    log.debug(entry.getKey() + " = " + entry.getValue());
                }
            }
            context.setVariable(Citrus.TEST_NAME_VARIABLE, this.getName());
            context.setVariable(Citrus.TEST_PACKAGE_VARIABLE, this.packageName);
            for (Map.Entry<String, Object> paramEntry : this.parameters.entrySet()) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Initializing test parameter '%s' as variable", paramEntry.getKey()));
                }
                context.setVariable(paramEntry.getKey(), paramEntry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.variableDefinitions.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof String) {
                    context.setVariable(key, context.replaceDynamicContentInString(value.toString()));
                    continue;
                }
                context.setVariable(key, value);
            }
            if (context.hasVariables() && log.isDebugEnabled()) {
                log.debug("Test variables:");
                for (Map.Entry<String, Object> entry : context.getVariables().entrySet()) {
                    log.debug(entry.getKey() + " = " + entry.getValue());
                }
            }
            this.beforeTest(context);
        }
        catch (AssertionError | Exception e) {
            this.testResult = TestResult.failed(this.getName(), this.testClass.getName(), (Throwable)e);
            throw new TestCaseFailedException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute(TestContext context) {
        if (!this.getMetaInfo().getStatus().equals((Object)TestCaseMetaInfo.Status.DISABLED)) {
            try {
                this.start(context);
                for (TestAction action : this.actions) {
                    this.executeAction(action, context);
                }
                this.testResult = TestResult.success(this.getName(), this.testClass.getName());
            }
            catch (TestCaseFailedException e) {
                throw e;
            }
            catch (AssertionError | Exception e) {
                this.testResult = TestResult.failed(this.getName(), this.testClass.getName(), (Throwable)e);
                throw new TestCaseFailedException((Throwable)e);
            }
            finally {
                try {
                    if (!CollectionUtils.isEmpty(context.getExceptions())) {
                        CitrusRuntimeException ex = context.getExceptions().remove(0);
                        this.testResult = TestResult.failed(this.getName(), this.testClass.getName(), ex);
                        throw new TestCaseFailedException(ex);
                    }
                }
                finally {
                    this.finish(context);
                }
            }
        }
        this.testResult = TestResult.skipped(this.getName(), this.testClass.getName());
        context.getTestListeners().onTestSkipped(this);
    }

    public void beforeTest(TestContext context) {
        if (this.beforeTest != null) {
            for (SequenceBeforeTest sequenceBeforeTest : this.beforeTest) {
                try {
                    if (!sequenceBeforeTest.shouldExecute(this.getName(), this.packageName, this.groups)) continue;
                    sequenceBeforeTest.execute(context);
                }
                catch (Exception e) {
                    throw new CitrusRuntimeException("Before test failed with errors", e);
                }
            }
        }
    }

    public void afterTest(TestContext context) {
        if (this.afterTest != null) {
            for (SequenceAfterTest sequenceAfterTest : this.afterTest) {
                try {
                    if (!sequenceAfterTest.shouldExecute(this.getName(), this.packageName, this.groups)) continue;
                    sequenceAfterTest.execute(context);
                }
                catch (Exception e) {
                    log.warn("After test failed with errors", (Throwable)e);
                }
                catch (AssertionError e) {
                    log.warn("After test failed with errors", (Throwable)((Object)e));
                }
            }
        }
    }

    public void executeAction(TestAction action, TestContext context) {
        if (!CollectionUtils.isEmpty(context.getExceptions())) {
            throw context.getExceptions().remove(0);
        }
        try {
            if (!action.isDisabled(context)) {
                this.testActionListeners.onTestActionStart(this, action);
                this.setActiveAction(action);
                action.execute(context);
                this.testActionListeners.onTestActionFinish(this, action);
            } else {
                this.testActionListeners.onTestActionSkipped(this, action);
            }
        }
        catch (AssertionError | Exception e) {
            this.testResult = TestResult.failed(this.getName(), this.testClass.getName(), (Throwable)e);
            throw new TestCaseFailedException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(TestContext context) {
        Object runtimeException = null;
        if (CollectionUtils.isEmpty(context.getExceptions()) && Optional.ofNullable(this.testResult).map(TestResult::isSuccess).orElse(false).booleanValue()) {
            try {
                CompletableFuture finished = new CompletableFuture();
                Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
                    if (this.isDone(context)) {
                        finished.complete(true);
                    } else {
                        log.debug("Wait for test actions to finish properly ...");
                    }
                }, 100L, this.timeout / 10L, TimeUnit.MILLISECONDS);
                finished.get(this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                runtimeException = new CitrusRuntimeException("Failed to wait for nested test actions to finish properly", e);
            }
            finally {
                if (!CollectionUtils.isEmpty(context.getExceptions())) {
                    CitrusRuntimeException ex = context.getExceptions().remove(0);
                    this.testResult = TestResult.failed(this.getName(), this.testClass.getName(), ex);
                    runtimeException = ex;
                }
            }
        }
        context.getTestListeners().onTestFinish(this);
        try {
            if (!this.finalActions.isEmpty()) {
                log.debug("Entering finally block in test case");
                for (TestAction action : this.finalActions) {
                    if (!action.isDisabled(context)) {
                        this.testActionListeners.onTestActionStart(this, action);
                        action.execute(context);
                        this.testActionListeners.onTestActionFinish(this, action);
                        continue;
                    }
                    this.testActionListeners.onTestActionSkipped(this, action);
                }
            }
            if (this.testResult == null) {
                this.testResult = TestResult.success(this.getName(), this.testClass.getName());
            }
            if (runtimeException != null) {
                throw runtimeException;
            }
        }
        catch (AssertionError | Exception e) {
            this.testResult = TestResult.failed(this.getName(), this.testClass.getName(), (Throwable)e);
            throw new TestCaseFailedException((Throwable)e);
        }
        finally {
            if (this.testResult.isSuccess()) {
                context.getTestListeners().onTestSuccess(this);
            } else {
                context.getTestListeners().onTestFailure(this, this.testResult.getCause());
            }
            this.afterTest(context);
        }
    }

    public void setVariableDefinitions(Map<String, Object> variableDefinitions) {
        this.variableDefinitions = variableDefinitions;
    }

    public Map<String, Object> getVariableDefinitions() {
        return this.variableDefinitions;
    }

    public void setFinalActions(List<TestAction> finalActions) {
        this.finalActions = finalActions;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[testVariables:");
        for (Map.Entry<String, Object> entry : this.variableDefinitions.entrySet()) {
            buf.append(entry.getKey()).append("=").append(entry.getValue().toString()).append(";");
        }
        buf.append("] ");
        buf.append("[testActions:");
        for (TestAction action : this.actions) {
            buf.append(action.getClass().getName()).append(";");
        }
        buf.append("] ");
        return super.toString() + buf.toString();
    }

    public void addFinalAction(TestAction testAction) {
        this.finalActions.add(testAction);
    }

    public TestCaseMetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public void setMetaInfo(TestCaseMetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public List<TestAction> getFinalActions() {
        return this.finalActions;
    }

    public void setBeanName(String name) {
        if (this.getName() == null) {
            this.setName(name);
        }
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setTestClass(Class<?> type) {
        this.testClass = type;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public void setParameters(String[] parameterNames, Object[] parameterValues) {
        if (parameterNames.length != parameterValues.length) {
            throw new CitrusRuntimeException(String.format("Invalid test parameter usage - received '%s' parameters with '%s' values", parameterNames.length, parameterValues.length));
        }
        for (int i = 0; i < parameterNames.length; ++i) {
            if (parameterValues[i] == null) continue;
            this.parameters.put(parameterNames[i], parameterValues[i]);
        }
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setTestActionListeners(TestActionListeners testActionListeners) {
        this.testActionListeners = testActionListeners;
    }

    public void setBeforeTest(List<SequenceBeforeTest> beforeTest) {
        this.beforeTest = beforeTest;
    }

    public void setAfterTest(List<SequenceAfterTest> afterTest) {
        this.afterTest = afterTest;
    }

    public void setTestRunner(boolean testRunner) {
        this.testRunner = testRunner;
    }

    public boolean isTestRunner() {
        return this.testRunner;
    }

    public void setTestResult(TestResult testResult) {
        this.testResult = testResult;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public void setGroups(String[] groups) {
        this.groups = groups;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }
}

