/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus;

import com.consol.citrus.TestAction;
import com.consol.citrus.config.CitrusSpringConfig;
import com.consol.citrus.container.SequenceAfterSuite;
import com.consol.citrus.container.SequenceBeforeSuite;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.context.TestContextFactory;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.report.TestListener;
import com.consol.citrus.report.TestListeners;
import com.consol.citrus.report.TestSuiteListener;
import com.consol.citrus.report.TestSuiteListeners;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class Citrus {
    private static Logger log = LoggerFactory.getLogger(Citrus.class);
    private static String version;
    private static InstanceStrategy strategy;
    private static final String APPLICATION_PROPERTY_FILE_PROPERTY = "citrus.application.properties";
    private static final String APPLICATION_PROPERTY_FILE_ENV = "CITRUS_APPLICATION_PROPERTIES";
    private static final String APPLICATION_PROPERTY_FILE;
    public static final String TEST_NAME_VARIABLE_PROPERTY = "citrus.test.name.variable";
    public static final String TEST_NAME_VARIABLE_ENV = "CITRUS_TEST_NAME_VARIABLE";
    public static final String TEST_NAME_VARIABLE;
    public static final String TEST_PACKAGE_VARIABLE_PROPERTY = "citrus.test.package.variable";
    public static final String TEST_PACKAGE_VARIABLE_ENV = "CITRUS_TEST_PACKAGE_VARIABLE";
    public static final String TEST_PACKAGE_VARIABLE;
    public static final String CITRUS_FILE_ENCODING_PROPERTY = "citrus.file.encoding";
    public static final String CITRUS_FILE_ENCODING_ENV = "CITRUS_FILE_ENCODING";
    public static final String CITRUS_FILE_ENCODING;
    public static final String VARIABLE_PREFIX = "${";
    public static final String VARIABLE_SUFFIX = "}";
    public static final String VARIABLE_ESCAPE = "//";
    public static final String DEFAULT_APPLICATION_CONTEXT_PROPERTY = "citrus.spring.application.context";
    public static final String DEFAULT_APPLICATION_CONTEXT_ENV = "CITRUS_SPRING_APPLICATION_CONTEXT";
    public static final String DEFAULT_APPLICATION_CONTEXT;
    public static final String DEFAULT_APPLICATION_CONTEXT_CLASS_PROPERTY = "citrus.spring.java.config";
    public static final String DEFAULT_APPLICATION_CONTEXT_CLASS_ENV = "CITRUS_SPRING_JAVA_CONFIG";
    public static final String DEFAULT_APPLICATION_CONTEXT_CLASS;
    public static final String DEFAULT_TEST_SRC_DIRECTORY_PROPERTY = "citrus.default.src.directory";
    public static final String DEFAULT_TEST_SRC_DIRECTORY_ENV = "CITRUS_DEFAULT_SRC_DIRECTORY";
    public static final String DEFAULT_TEST_SRC_DIRECTORY;
    public static final String IGNORE_PLACEHOLDER = "@ignore@";
    public static final String VALIDATION_MATCHER_PREFIX = "@";
    public static final String VALIDATION_MATCHER_SUFFIX = "@";
    public static final String XML_TEST_FILE_NAME_PATTERN_PROPERTY = "citrus.xml.file.name.pattern";
    public static final String XML_TEST_FILE_NAME_PATTERN_ENV = "CITRUS_XML_FILE_NAME_PATTERN";
    public static final String XML_TEST_FILE_NAME_PATTERN;
    public static final String JAVA_TEST_FILE_NAME_PATTERN_PROPERTY = "citrus.java.file.name.pattern";
    public static final String JAVA_TEST_FILE_NAME_PATTERN_ENV = "CITRUS_JAVA_FILE_NAME_PATTERN";
    public static final String JAVA_TEST_FILE_NAME_PATTERN;
    public static final String DEFAULT_MESSAGE_TYPE_PROPERTY = "citrus.default.message.type";
    public static final String DEFAULT_MESSAGE_TYPE_ENV = "CITRUS_DEFAULT_MESSAGE_TYPE";
    public static final String DEFAULT_MESSAGE_TYPE;
    private TestContextFactory testContextFactory;
    private TestSuiteListeners testSuiteListener;
    private TestListeners testListener;
    private Collection<SequenceBeforeSuite> beforeSuite;
    private Collection<SequenceAfterSuite> afterSuite;
    private ApplicationContext applicationContext;

    private Citrus(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.testListener = (TestListeners)applicationContext.getBean(TestListeners.class);
        this.testSuiteListener = (TestSuiteListeners)applicationContext.getBean(TestSuiteListeners.class);
        this.testContextFactory = (TestContextFactory)applicationContext.getBean(TestContextFactory.class);
        this.beforeSuite = applicationContext.getBeansOfType(SequenceBeforeSuite.class).values();
        this.afterSuite = applicationContext.getBeansOfType(SequenceAfterSuite.class).values();
    }

    public static Citrus newInstance() {
        return CitrusInstanceManager.newInstance((ApplicationContext)new AnnotationConfigApplicationContext(new Class[]{CitrusSpringConfig.class}));
    }

    public static Citrus newInstance(Class<? extends CitrusSpringConfig> configClass) {
        return CitrusInstanceManager.newInstance((ApplicationContext)new AnnotationConfigApplicationContext(new Class[]{configClass}));
    }

    public static Citrus newInstance(ApplicationContext applicationContext) {
        return CitrusInstanceManager.newInstance(applicationContext);
    }

    public void beforeSuite(String suiteName, String ... testGroups) {
        this.testSuiteListener.onStart();
        if (!CollectionUtils.isEmpty(this.beforeSuite)) {
            for (SequenceBeforeSuite sequenceBeforeSuite : this.beforeSuite) {
                try {
                    if (!sequenceBeforeSuite.shouldExecute(suiteName, testGroups)) continue;
                    sequenceBeforeSuite.execute(this.createTestContext());
                }
                catch (Exception e) {
                    this.testSuiteListener.onStartFailure(e);
                    this.afterSuite(suiteName, testGroups);
                    throw new AssertionError("Before suite failed with errors", e);
                }
            }
            this.testSuiteListener.onStartSuccess();
        } else {
            this.testSuiteListener.onStartSuccess();
        }
    }

    public void afterSuite(String suiteName, String ... testGroups) {
        this.testSuiteListener.onFinish();
        if (!CollectionUtils.isEmpty(this.afterSuite)) {
            for (SequenceAfterSuite sequenceAfterSuite : this.afterSuite) {
                try {
                    if (!sequenceAfterSuite.shouldExecute(suiteName, testGroups)) continue;
                    sequenceAfterSuite.execute(this.createTestContext());
                }
                catch (Exception e) {
                    this.testSuiteListener.onFinishFailure(e);
                    throw new AssertionError("After suite failed with errors", e);
                }
            }
            this.testSuiteListener.onFinishSuccess();
        } else {
            this.testSuiteListener.onFinishSuccess();
        }
    }

    public static Set<String> getXmlTestFileNamePattern() {
        return StringUtils.commaDelimitedListToSet((String)XML_TEST_FILE_NAME_PATTERN);
    }

    public static Set<String> getJavaTestFileNamePattern() {
        return StringUtils.commaDelimitedListToSet((String)JAVA_TEST_FILE_NAME_PATTERN);
    }

    public void run(TestAction action) {
        this.run(action, this.createTestContext());
    }

    public void run(TestAction action, TestContext testContext) {
        action.execute(testContext);
    }

    public TestContext createTestContext() {
        return this.testContextFactory.getObject();
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public static String getVersion() {
        return version;
    }

    public void addTestSuiteListener(TestSuiteListener suiteListener) {
        this.testSuiteListener.addTestSuiteListener(suiteListener);
    }

    public void addTestListener(TestListener testListener) {
        this.testListener.addTestListener(testListener);
    }

    public static void mode(InstanceStrategy mode) {
        strategy = mode;
    }

    public void close() {
        if (this.applicationContext instanceof ConfigurableApplicationContext && ((ConfigurableApplicationContext)this.applicationContext).isActive()) {
            ((ConfigurableApplicationContext)this.applicationContext).close();
        }
    }

    static {
        strategy = InstanceStrategy.NEW;
        try (InputStream in = new ClassPathResource("META-INF/citrus.version").getInputStream();){
            Properties versionProperties = new Properties();
            versionProperties.load(in);
            version = versionProperties.get("citrus.version").toString();
            if (version.equals("${project.version}")) {
                log.warn("Citrus version has not been filtered with Maven project properties yet");
                version = "";
            }
        }
        catch (IOException e) {
            log.warn("Unable to read Citrus version information", (Throwable)e);
            version = "";
        }
        APPLICATION_PROPERTY_FILE = System.getProperty(APPLICATION_PROPERTY_FILE_PROPERTY, System.getenv(APPLICATION_PROPERTY_FILE_ENV) != null ? System.getenv(APPLICATION_PROPERTY_FILE_ENV) : "classpath:citrus-application.properties");
        Resource appPropertiesResource = new PathMatchingResourcePatternResolver().getResource(APPLICATION_PROPERTY_FILE);
        if (appPropertiesResource.exists()) {
            try (InputStream in = appPropertiesResource.getInputStream();){
                Properties applicationProperties = new Properties();
                applicationProperties.load(in);
                log.debug("Loading Citrus application properties");
                for (Map.Entry<Object, Object> property : applicationProperties.entrySet()) {
                    if (!StringUtils.isEmpty((Object)System.getProperty(property.getKey().toString()))) continue;
                    log.debug(String.format("Setting application property %s=%s", property.getKey(), property.getValue()));
                    System.setProperty(property.getKey().toString(), property.getValue().toString());
                }
            }
            catch (Exception e) {
                if (log.isTraceEnabled()) {
                    log.trace("Unable to locate Citrus application properties", (Throwable)e);
                }
                log.info("Unable to locate Citrus application properties");
            }
        }
        TEST_NAME_VARIABLE = System.getProperty(TEST_NAME_VARIABLE_PROPERTY, System.getenv(TEST_NAME_VARIABLE_ENV) != null ? System.getenv(TEST_NAME_VARIABLE_ENV) : "citrus.test.name");
        TEST_PACKAGE_VARIABLE = System.getProperty(TEST_PACKAGE_VARIABLE_PROPERTY, System.getenv(TEST_PACKAGE_VARIABLE_ENV) != null ? System.getenv(TEST_PACKAGE_VARIABLE_ENV) : "citrus.test.package");
        CITRUS_FILE_ENCODING = System.getProperty(CITRUS_FILE_ENCODING_PROPERTY, System.getenv(CITRUS_FILE_ENCODING_ENV) != null ? System.getenv(CITRUS_FILE_ENCODING_ENV) : Charset.defaultCharset().displayName());
        DEFAULT_APPLICATION_CONTEXT = System.getProperty(DEFAULT_APPLICATION_CONTEXT_PROPERTY, System.getenv(DEFAULT_APPLICATION_CONTEXT_ENV) != null ? System.getenv(DEFAULT_APPLICATION_CONTEXT_ENV) : "classpath*:citrus-context.xml");
        DEFAULT_APPLICATION_CONTEXT_CLASS = System.getProperty(DEFAULT_APPLICATION_CONTEXT_CLASS_PROPERTY, System.getenv(DEFAULT_APPLICATION_CONTEXT_CLASS_ENV));
        DEFAULT_TEST_SRC_DIRECTORY = System.getProperty(DEFAULT_TEST_SRC_DIRECTORY_PROPERTY, System.getenv(DEFAULT_TEST_SRC_DIRECTORY_ENV) != null ? System.getenv(DEFAULT_TEST_SRC_DIRECTORY_ENV) : "src" + File.separator + "test" + File.separator);
        XML_TEST_FILE_NAME_PATTERN = System.getProperty(XML_TEST_FILE_NAME_PATTERN_PROPERTY, System.getenv(XML_TEST_FILE_NAME_PATTERN_ENV) != null ? System.getenv(XML_TEST_FILE_NAME_PATTERN_ENV) : "/**/*Test.xml,/**/*IT.xml");
        JAVA_TEST_FILE_NAME_PATTERN = System.getProperty(JAVA_TEST_FILE_NAME_PATTERN_PROPERTY, System.getenv(JAVA_TEST_FILE_NAME_PATTERN_ENV) != null ? System.getenv(JAVA_TEST_FILE_NAME_PATTERN_ENV) : "/**/*Test.java,/**/*IT.java");
        DEFAULT_MESSAGE_TYPE = System.getProperty(DEFAULT_MESSAGE_TYPE_PROPERTY, System.getenv(DEFAULT_MESSAGE_TYPE_ENV) != null ? System.getenv(DEFAULT_MESSAGE_TYPE_ENV) : MessageType.XML.toString());
    }

    public static class CitrusInstanceManager {
        private static Citrus citrus;
        private static List<InstanceProcessor> instanceProcessors;

        public static void addInstanceProcessor(InstanceProcessor processor) {
            instanceProcessors.add(processor);
        }

        public static Citrus newInstance() {
            if (strategy.equals((Object)InstanceStrategy.NEW)) {
                Citrus instance = CitrusInstanceManager.newInstance((ApplicationContext)new AnnotationConfigApplicationContext(new Class[]{CitrusSpringConfig.class}));
                instanceProcessors.forEach(processor -> processor.process(instance));
                return instance;
            }
            if (citrus == null) {
                citrus = CitrusInstanceManager.newInstance((ApplicationContext)new AnnotationConfigApplicationContext(new Class[]{CitrusSpringConfig.class}));
                instanceProcessors.forEach(processor -> processor.process(citrus));
            }
            return citrus;
        }

        public static Citrus newInstance(Class<? extends CitrusSpringConfig> configClass) {
            if (strategy.equals((Object)InstanceStrategy.NEW)) {
                Citrus instance = CitrusInstanceManager.newInstance((ApplicationContext)new AnnotationConfigApplicationContext(new Class[]{configClass}));
                instanceProcessors.forEach(processor -> processor.process(instance));
                return instance;
            }
            if (citrus == null) {
                citrus = CitrusInstanceManager.newInstance((ApplicationContext)new AnnotationConfigApplicationContext(new Class[]{configClass}));
                instanceProcessors.forEach(processor -> processor.process(citrus));
            }
            return citrus;
        }

        public static Citrus newInstance(ApplicationContext applicationContext) {
            if (strategy.equals((Object)InstanceStrategy.NEW)) {
                Citrus instance = new Citrus(applicationContext);
                instanceProcessors.forEach(processor -> processor.process(instance));
                return instance;
            }
            if (citrus == null) {
                citrus = new Citrus(applicationContext);
                instanceProcessors.forEach(processor -> processor.process(citrus));
            }
            return citrus;
        }

        public static Citrus getSingleton() {
            return citrus;
        }

        static {
            instanceProcessors = new ArrayList<InstanceProcessor>();
        }
    }

    public static enum InstanceStrategy {
        NEW,
        SINGLETON;

    }

    public static interface InstanceProcessor {
        public void process(Citrus var1);
    }
}

