/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.barcode;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.telephony.PhoneNumberUtils;
import com.configureit.barcode.Contents;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.util.EnumMap;
import java.util.HashSet;

public final class QRCodeEncoder {
    private static final int WHITE = -1;
    private static final int BLACK = -16777216;
    private int dimension = Integer.MIN_VALUE;
    private String contents = null;
    private String displayContents = null;
    private String title = null;
    private BarcodeFormat format = null;
    private boolean encoded = false;

    public QRCodeEncoder(String data, Bundle bundle, String type, String format, int dimension) {
        this.dimension = dimension;
        this.encoded = this.encodeContents(data, bundle, type, format);
    }

    public String getContents() {
        return this.contents;
    }

    public String getDisplayContents() {
        return this.displayContents;
    }

    public String getTitle() {
        return this.title;
    }

    private boolean encodeContents(String data, Bundle bundle, String type, String formatString) {
        this.format = null;
        if (formatString != null) {
            try {
                this.format = BarcodeFormat.valueOf((String)formatString);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        if (this.format == null || this.format == BarcodeFormat.QR_CODE) {
            this.format = BarcodeFormat.QR_CODE;
            this.encodeQRCodeContents(data, bundle, type);
        } else if (data != null && data.length() > 0) {
            this.contents = data;
            this.displayContents = data;
            this.title = "Text";
        }
        return this.contents != null && this.contents.length() > 0;
    }

    private void encodeQRCodeContents(String data, Bundle bundle, String type) {
        if (type.equals("TEXT_TYPE")) {
            if (data != null && data.length() > 0) {
                this.contents = data;
                this.displayContents = data;
                this.title = "Text";
            }
        } else if (type.equals("EMAIL_TYPE")) {
            if ((data = QRCodeEncoder.trim(data)) != null) {
                this.contents = "mailto:" + data;
                this.displayContents = data;
                this.title = "E-Mail";
            }
        } else if (type.equals("PHONE_TYPE")) {
            if ((data = QRCodeEncoder.trim(data)) != null) {
                this.contents = "tel:" + data;
                this.displayContents = PhoneNumberUtils.formatNumber((String)data);
                this.title = "Phone";
            }
        } else if (type.equals("SMS_TYPE")) {
            if ((data = QRCodeEncoder.trim(data)) != null) {
                this.contents = "sms:" + data;
                this.displayContents = PhoneNumberUtils.formatNumber((String)data);
                this.title = "SMS";
            }
        } else if (type.equals("CONTACT_TYPE")) {
            if (bundle != null) {
                String note;
                String address;
                StringBuilder newContents = new StringBuilder(100);
                StringBuilder newDisplayContents = new StringBuilder(100);
                newContents.append("MECARD:");
                String name = QRCodeEncoder.trim(bundle.getString("name"));
                if (name != null) {
                    newContents.append("N:").append(QRCodeEncoder.escapeMECARD(name)).append(';');
                    newDisplayContents.append(name);
                }
                if ((address = QRCodeEncoder.trim(bundle.getString("postal"))) != null) {
                    newContents.append("ADR:").append(QRCodeEncoder.escapeMECARD(address)).append(';');
                    newDisplayContents.append('\n').append(address);
                }
                HashSet<String> uniquePhones = new HashSet<String>(Contents.PHONE_KEYS.length);
                for (int x = 0; x < Contents.PHONE_KEYS.length; ++x) {
                    String phone = QRCodeEncoder.trim(bundle.getString(Contents.PHONE_KEYS[x]));
                    if (phone == null) continue;
                    uniquePhones.add(phone);
                }
                for (String phone : uniquePhones) {
                    newContents.append("TEL:").append(QRCodeEncoder.escapeMECARD(phone)).append(';');
                    newDisplayContents.append('\n').append(PhoneNumberUtils.formatNumber((String)phone));
                }
                HashSet<String> uniqueEmails = new HashSet<String>(Contents.EMAIL_KEYS.length);
                for (int x = 0; x < Contents.EMAIL_KEYS.length; ++x) {
                    String email = QRCodeEncoder.trim(bundle.getString(Contents.EMAIL_KEYS[x]));
                    if (email == null) continue;
                    uniqueEmails.add(email);
                }
                for (String email : uniqueEmails) {
                    newContents.append("EMAIL:").append(QRCodeEncoder.escapeMECARD(email)).append(';');
                    newDisplayContents.append('\n').append(email);
                }
                String url = QRCodeEncoder.trim(bundle.getString("URL_KEY"));
                if (url != null) {
                    newContents.append("URL:").append(url).append(';');
                    newDisplayContents.append('\n').append(url);
                }
                if ((note = QRCodeEncoder.trim(bundle.getString("NOTE_KEY"))) != null) {
                    newContents.append("NOTE:").append(QRCodeEncoder.escapeMECARD(note)).append(';');
                    newDisplayContents.append('\n').append(note);
                }
                if (newDisplayContents.length() > 0) {
                    newContents.append(';');
                    this.contents = newContents.toString();
                    this.displayContents = newDisplayContents.toString();
                    this.title = "Contact";
                } else {
                    this.contents = null;
                    this.displayContents = null;
                }
            }
        } else if (type.equals("LOCATION_TYPE") && bundle != null) {
            float latitude = bundle.getFloat("LAT", Float.MAX_VALUE);
            float longitude = bundle.getFloat("LONG", Float.MAX_VALUE);
            if (latitude != Float.MAX_VALUE && longitude != Float.MAX_VALUE) {
                this.contents = "geo:" + latitude + ',' + longitude;
                this.displayContents = latitude + "," + longitude;
                this.title = "Location";
            }
        }
    }

    public Bitmap encodeAsBitmap() throws WriterException {
        if (!this.encoded) {
            return null;
        }
        EnumMap<EncodeHintType, String> hints = null;
        String encoding = QRCodeEncoder.guessAppropriateEncoding(this.contents);
        if (encoding != null) {
            hints = new EnumMap<EncodeHintType, String>(EncodeHintType.class);
            hints.put(EncodeHintType.CHARACTER_SET, encoding);
        }
        MultiFormatWriter writer = new MultiFormatWriter();
        BitMatrix result = writer.encode(this.contents, this.format, this.dimension, this.dimension, hints);
        int width = result.getWidth();
        int height = result.getHeight();
        int[] pixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                pixels[offset + x] = result.get(x, y) ? -16777216 : -1;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return bitmap;
    }

    private static String guessAppropriateEncoding(CharSequence contents) {
        for (int i = 0; i < contents.length(); ++i) {
            if (contents.charAt(i) <= '\u00ff') continue;
            return "UTF-8";
        }
        return null;
    }

    private static String trim(String s) {
        if (s == null) {
            return null;
        }
        String result = s.trim();
        return result.length() == 0 ? null : result;
    }

    private static String escapeMECARD(String input) {
        if (input == null || input.indexOf(58) < 0 && input.indexOf(59) < 0) {
            return input;
        }
        int length = input.length();
        StringBuilder result = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            if (c == ':' || c == ';') {
                result.append('\\');
            }
            result.append(c);
        }
        return result.toString();
    }
}

