/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.barcode;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.configureit.barcode.BarcodeCallback;
import com.configureit.barcode.BarcodeResult;
import com.configureit.barcode.BarcodeView;
import com.configureit.barcode.CameraSettings;
import com.configureit.barcode.DecodeFormatManager;
import com.configureit.barcode.DecodeHintManager;
import com.configureit.barcode.DefaultDecoderFactory;
import com.configureit.barcode.ViewfinderView;
import com.configureit.utils.barcode.R;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.ResultPoint;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompoundBarcodeView
extends FrameLayout {
    private BarcodeView barcodeView;
    private ViewfinderView viewFinder;
    private TextView statusView;
    private CheckBox chkTorch;
    private TorchListener torchListener;

    public CompoundBarcodeView(Context context) {
        super(context);
        this.initialize();
    }

    public CompoundBarcodeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(attrs);
    }

    public CompoundBarcodeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(attrs);
    }

    private void initialize(AttributeSet attrs) {
        TypedArray attributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.zxing_view);
        int scannerLayout = attributes.getResourceId(R.styleable.zxing_view_zxing_scanner_layout, R.layout.zxing_barcode_scanner);
        attributes.recycle();
        CompoundBarcodeView.inflate((Context)this.getContext(), (int)scannerLayout, (ViewGroup)this);
        this.barcodeView = (BarcodeView)this.findViewById(R.id.zxing_barcode_surface);
        this.chkTorch = (CheckBox)this.findViewById(R.id.zxing_torch);
        this.chkTorch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                CompoundBarcodeView.this.barcodeView.setTorch(isChecked);
                CompoundBarcodeView.this.setTorchPreference(CompoundBarcodeView.this.getContext(), isChecked);
            }
        });
        if (this.barcodeView == null) {
            throw new IllegalArgumentException("There is no a com.journeyapps.barcodescanner.BarcodeView on provided layout with the id \"zxing_barcode_surface\".");
        }
        this.barcodeView.initializeAttributes(attrs);
        this.viewFinder = (ViewfinderView)this.findViewById(R.id.zxing_viewfinder_view);
        if (this.viewFinder == null) {
            throw new IllegalArgumentException("There is no a com.journeyapps.barcodescanner.ViewfinderView on provided layout with the id \"zxing_viewfinder_view\".");
        }
        this.viewFinder.setCameraPreview(this.barcodeView);
        this.statusView = (TextView)this.findViewById(R.id.zxing_status_view);
    }

    private void initialize() {
        this.initialize(null);
    }

    public void initializeFromIntent(Intent intent) {
        String customPromptMessage;
        int cameraId;
        Set<BarcodeFormat> decodeFormats = DecodeFormatManager.parseDecodeFormats(intent);
        Map<DecodeHintType, Object> decodeHints = DecodeHintManager.parseDecodeHints(intent);
        CameraSettings settings = new CameraSettings();
        if (intent.hasExtra("SCAN_CAMERA_ID") && (cameraId = intent.getIntExtra("SCAN_CAMERA_ID", -1)) >= 0) {
            settings.setRequestedCameraId(cameraId);
        }
        if ((customPromptMessage = intent.getStringExtra("PROMPT_MESSAGE")) != null) {
            this.setStatusText(customPromptMessage);
        }
        String characterSet = intent.getStringExtra("CHARACTER_SET");
        MultiFormatReader reader = new MultiFormatReader();
        reader.setHints(decodeHints);
        this.barcodeView.setCameraSettings(settings);
        this.barcodeView.setDecoderFactory(new DefaultDecoderFactory(decodeFormats, decodeHints, characterSet));
    }

    public void setStatusText(String text) {
        if (this.statusView != null) {
            this.statusView.setText((CharSequence)text);
        }
    }

    public void pause() {
        this.barcodeView.pause();
    }

    public void resume() {
        this.barcodeView.resume();
    }

    public BarcodeView getBarcodeView() {
        return (BarcodeView)this.findViewById(R.id.zxing_barcode_surface);
    }

    public ViewfinderView getViewFinder() {
        return this.viewFinder;
    }

    public TextView getStatusView() {
        return this.statusView;
    }

    public void decodeSingle(BarcodeCallback callback) {
        this.barcodeView.decodeSingle(new WrappedCallback(callback));
    }

    public void decodeContinuous(BarcodeCallback callback) {
        this.barcodeView.decodeContinuous(new WrappedCallback(callback));
    }

    public void setTorchOn() {
        this.chkTorch.setChecked(true);
        if (this.torchListener != null) {
            this.torchListener.onTorchOn();
        }
    }

    public void setTorchOff() {
        this.chkTorch.setChecked(false);
        if (this.torchListener != null) {
            this.torchListener.onTorchOff();
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 27: 
            case 80: {
                return true;
            }
            case 25: {
                this.setTorchOff();
                return true;
            }
            case 24: {
                this.setTorchOn();
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public void setTorchListener(TorchListener listener) {
        this.torchListener = listener;
    }

    private void setTorchPreference(Context context, boolean on) {
        try {
            SharedPreferences sharedPreferences = context.getSharedPreferences("BarcodePref", 0);
            sharedPreferences.edit().putBoolean("cit_barcode_torch", on).apply();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isTorchOn(Context context) {
        try {
            SharedPreferences sharedPreferences = context.getSharedPreferences("BarcodePref", 0);
            return sharedPreferences.getBoolean("cit_barcode_torch", false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void loadTorchData() {
        this.chkTorch.setChecked(this.isTorchOn(this.getContext()));
    }

    public static interface TorchListener {
        public void onTorchOn();

        public void onTorchOff();
    }

    private class WrappedCallback
    implements BarcodeCallback {
        private BarcodeCallback delegate;

        public WrappedCallback(BarcodeCallback delegate) {
            this.delegate = delegate;
        }

        @Override
        public void barcodeResult(BarcodeResult result) {
            this.delegate.barcodeResult(result);
        }

        @Override
        public void possibleResultPoints(List<ResultPoint> resultPoints) {
            for (ResultPoint point : resultPoints) {
                CompoundBarcodeView.this.viewFinder.addPossibleResultPoint(point);
            }
            this.delegate.possibleResultPoints(resultPoints);
        }
    }
}

