/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.barcode;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import com.configureit.barcode.CaptureManager;
import com.configureit.barcode.CompoundBarcodeView;
import com.configureit.utils.barcode.R;

public class CaptureActivity
extends Activity {
    private CaptureManager capture;
    private CompoundBarcodeView barcodeScannerView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.barcodeScannerView = this.initializeContent();
        this.barcodeScannerView.loadTorchData();
        this.capture = new CaptureManager(this, this.barcodeScannerView);
        this.capture.initializeFromIntent(this.getIntent(), savedInstanceState);
        this.capture.decode();
    }

    protected CompoundBarcodeView initializeContent() {
        this.setContentView(R.layout.zxing_capture);
        return (CompoundBarcodeView)this.findViewById(R.id.zxing_barcode_scanner);
    }

    protected void onResume() {
        super.onResume();
        this.capture.onResume();
    }

    protected void onPause() {
        super.onPause();
        this.capture.onPause();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.capture.onDestroy();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.capture.onSaveInstanceState(outState);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        this.capture.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.capture.onActivityResult(requestCode, resultCode, data);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return this.barcodeScannerView.onKeyDown(keyCode, event) || super.onKeyDown(keyCode, event);
    }

    public void onBackPressed() {
        try {
            Intent intent = new Intent("com.google.zxing.client.android.SCAN");
            intent.addFlags(524288);
            if (CaptureManager.inputBundle != null) {
                CaptureManager.inputBundle.putString("success", "0");
                intent.putExtras(CaptureManager.inputBundle);
            }
            this.setResult(0, intent);
            this.finish();
        }
        catch (Exception e) {
            super.onBackPressed();
        }
    }
}

