package com.configureit.barcode;

import android.Manifest;
import android.app.Activity;
import android.app.Dialog;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;

import com.configureit.citpermissionlib.PermissionDialogClickListener;
import com.configureit.citpermissionlib.PermissionUtils;
import com.configureit.citpermissionlib.Permissions;
import com.configureit.utils.barcode.R;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;

import static android.app.Activity.RESULT_OK;

public class GenerateQRCodeActivity extends AppCompatActivity {

    private static final int STORAGE_PERMISSION_REQ_CODE = 250;
    private static final int REQUEST_PERMISSION_SETTING = 39;
    public static final String REQ_ID = "req_id";
    public static final String INPUT_TEXT = "input";
    public static final String OUTPUT_WIDTH = "width";
    public static final String OUTPUT_HEIGHT = "height";
    public static final String OUTPUT_FILE_DIR = "SCAN_RESULT_IMAGE_STORAGE_DIR";

    private Intent intent;
    private String qrInputText;
    private String outputFileDir;
    private int width, height;
    private String outputFilePath;
    private boolean askedPermission = false;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        intent = getIntent();

        qrInputText = intent.getExtras().getString(INPUT_TEXT, null);
        outputFileDir = intent.getExtras().getString(OUTPUT_FILE_DIR, null);
        width = intent.getExtras().getInt(OUTPUT_WIDTH, 255);
        height = intent.getExtras().getInt(OUTPUT_HEIGHT, 255);
        if (ContextCompat.checkSelfPermission(this, Manifest.permission.WRITE_EXTERNAL_STORAGE)
                == PackageManager.PERMISSION_GRANTED) {
            new Thread(runnable).start();
        } else if (!askedPermission) {
            askedPermission = true;
            askPermissions("storage", Permissions.WRITE_EXTERNAL_STORAGE, (requestCode, isGrantedAll, allowPermissions, denyPermissions, neverAskPermissions) -> {
                if (isGrantedAll) {
                    new Thread(runnable).start();
                } else if (denyPermissions != null && denyPermissions.length > 0) {
                    setResult(new Intent(), RESULT_OK, "0", "0", "");
                    finish();
                } else if (neverAskPermissions != null && neverAskPermissions.length > 0) {
                    showPermissionErrorDialog(new PermissionDialogClickListener() {
                        @Override
                        public void positiveListener(Activity context, Dialog dialog) {

                        }

                        @Override
                        public void negativeListener(Activity context, Dialog dialog) {
                            setResult(new Intent(), RESULT_OK, "-1", "0", "");
                            finish();
                        }
                    });
                }
            });
//            ActivityCompat.requestPermissions(this, new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE}, STORAGE_PERMISSION_REQ_CODE);
        }
    }


    Runnable runnable = new Runnable() {
        @Override
        public void run() {
            int smallerDimension = width < height ? width : height;
//            smallerDimension = smallerDimension * 3/4;

            //Encode with a QR Code image
            QRCodeEncoder qrCodeEncoder = new QRCodeEncoder(qrInputText,
                    null,
                    Contents.Type.TEXT,
                    BarcodeFormat.QR_CODE.toString(),
                    smallerDimension);
            try {
                Bitmap resultBitmap = qrCodeEncoder.encodeAsBitmap();
                saveBitmapToFile(resultBitmap);
                handler.sendEmptyMessage(0);
            } catch (WriterException e) {
                e.printStackTrace();
            }
        }
    };

    Handler handler = new Handler(new Handler.Callback() {
        @Override
        public boolean handleMessage(Message msg) {
            if (!TextUtils.isEmpty(outputFilePath)) {
                intent.putExtra("result", outputFilePath);
                setResult(intent, RESULT_OK, "1", "1", outputFilePath);
            } else {
                intent.putExtra("result", outputFilePath);
                setResult(intent, RESULT_CANCELED, "1", "0", outputFilePath);
            }
            finish();
            return false;
        }
    });

    private void saveBitmapToFile(Bitmap bitmap) {
        FileOutputStream out = null;
        try {
            if (!TextUtils.isEmpty(outputFileDir)) {
                File f = new File(outputFileDir);
                if (f == null || !f.exists() || !f.isDirectory()) {
                    if (!f.mkdir()) {
                        f = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + outputFileDir);
                        f.mkdir();
                        outputFileDir = f.getAbsolutePath();
                    }
                }
            } else {
                outputFileDir = Environment.getExternalStorageDirectory().getAbsolutePath();
            }

            File f = new File(outputFileDir, UUID.randomUUID() + ".png");
            out = new FileOutputStream(f);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, out); // bmp is your Bitmap instance
            outputFilePath = f.getAbsolutePath();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (out != null) {
                    out.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void setResult(Intent intent, int intentResult, String successPermission, String success, String imagePath) {
        JSONObject resultJson = new JSONObject();
        try {
            resultJson.put("success_permission", successPermission);
            resultJson.put("success", success);
            resultJson.put("qr_image_path", imagePath);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        intent.putExtra("RESPONSE", resultJson.toString());
        setResult(intentResult, intent);
    }

    //======== [Permissions Start]================
    PermissionUtils mPermissionUtils;

    public void askPermissions(String controlId, String permissions, final PermissionUtils.PermissionCallback permissionCallback) {
        if (!TextUtils.isEmpty(permissions)) {
            String[] manifestPer = PermissionUtils.getPermission(permissions);
            if (manifestPer != null) {
                mPermissionUtils = new PermissionUtils.Builder(this, controlId)
                        .requestPermission(manifestPer)
                        .setCallback((requestCode, isGrantedAll, allowPermissions, denyPermissions, neverAskPermissions) -> {
                            if (permissionCallback != null)
                                permissionCallback.onResult(requestCode, isGrantedAll, allowPermissions, denyPermissions, neverAskPermissions);
                        })
                        .build();
                mPermissionUtils.execute();
            }
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (mPermissionUtils != null) {
            mPermissionUtils.onActivityResult(requestCode, resultCode, data);
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (mPermissionUtils != null) {
            mPermissionUtils.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }


    private void showPermissionErrorDialog(final PermissionDialogClickListener dialogInfoCallback) {
        mPermissionUtils.showPermissionErrorDialog(
                getString(R.string.permission_denied_title_barcode_generate),
                getString(R.string.permission_denied_message_barcode_generate),
                dialogInfoCallback);
    }
    //======== [Permissions End]================
}
