/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.barcode;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import com.configureit.barcode.PermissionDeniedDialog;
import com.configureit.barcode.PermissionDialogClickListener;
import com.configureit.barcode.PermissionUtils;
import com.configureit.barcode.QRCodeEncoder;
import com.configureit.utils.barcode.R;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class GenerateQRCodeActivity
extends AppCompatActivity {
    private static final int STORAGE_PERMISSION_REQ_CODE = 250;
    private static final int REQUEST_PERMISSION_SETTING = 39;
    public static final String REQ_ID = "req_id";
    public static final String INPUT_TEXT = "input";
    public static final String OUTPUT_WIDTH = "width";
    public static final String OUTPUT_HEIGHT = "height";
    public static final String OUTPUT_FILE_DIR = "SCAN_RESULT_IMAGE_STORAGE_DIR";
    private Intent intent;
    private String qrInputText;
    private String outputFileDir;
    private int width;
    private int height;
    private String outputFilePath;
    private boolean askedPermission = false;
    Runnable runnable = new Runnable(){

        @Override
        public void run() {
            int smallerDimension = GenerateQRCodeActivity.this.width < GenerateQRCodeActivity.this.height ? GenerateQRCodeActivity.this.width : GenerateQRCodeActivity.this.height;
            QRCodeEncoder qrCodeEncoder = new QRCodeEncoder(GenerateQRCodeActivity.this.qrInputText, null, "TEXT_TYPE", BarcodeFormat.QR_CODE.toString(), smallerDimension);
            try {
                Bitmap resultBitmap = qrCodeEncoder.encodeAsBitmap();
                GenerateQRCodeActivity.this.saveBitmapToFile(resultBitmap);
                GenerateQRCodeActivity.this.handler.sendEmptyMessage(0);
            }
            catch (WriterException e) {
                e.printStackTrace();
            }
        }
    };
    Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            if (!TextUtils.isEmpty((CharSequence)GenerateQRCodeActivity.this.outputFilePath)) {
                GenerateQRCodeActivity.this.intent.putExtra("result", GenerateQRCodeActivity.this.outputFilePath);
                GenerateQRCodeActivity.this.setResult(GenerateQRCodeActivity.this.intent, -1, "1", "1", GenerateQRCodeActivity.this.outputFilePath);
            } else {
                GenerateQRCodeActivity.this.intent.putExtra("result", GenerateQRCodeActivity.this.outputFilePath);
                GenerateQRCodeActivity.this.setResult(GenerateQRCodeActivity.this.intent, 0, "1", "0", GenerateQRCodeActivity.this.outputFilePath);
            }
            GenerateQRCodeActivity.this.finish();
            return false;
        }
    });

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.intent = this.getIntent();
        this.qrInputText = this.intent.getExtras().getString(INPUT_TEXT, null);
        this.outputFileDir = this.intent.getExtras().getString(OUTPUT_FILE_DIR, null);
        this.width = this.intent.getExtras().getInt(OUTPUT_WIDTH, 255);
        this.height = this.intent.getExtras().getInt(OUTPUT_HEIGHT, 255);
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
            new Thread(this.runnable).start();
        } else if (!this.askedPermission) {
            this.askedPermission = true;
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)250);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 250) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                new Thread(this.runnable).start();
            }
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)"android.permission.CAMERA")) {
                new PermissionDeniedDialog((Activity)this).showDialog(this.getString(R.string.permission_denied_title), this.getString(R.string.permission_denied_message), new PermissionDialogClickListener(){

                    @Override
                    public void positiveListener(Activity context, Dialog dialog) {
                        dialog.dismiss();
                        PermissionUtils.showExplicitPermissionSetting((Activity)GenerateQRCodeActivity.this, 39);
                    }

                    @Override
                    public void negativeListener(Activity context, Dialog dialog) {
                        dialog.dismiss();
                        GenerateQRCodeActivity.this.setResult(new Intent(), -1, "-1", "0", "");
                        GenerateQRCodeActivity.this.finish();
                    }
                });
            } else {
                this.setResult(new Intent(), -1, "0", "0", "");
                this.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBitmapToFile(Bitmap bitmap) {
        FileOutputStream out = null;
        try {
            File f;
            if (!TextUtils.isEmpty((CharSequence)this.outputFileDir)) {
                f = new File(this.outputFileDir);
                if (!(f != null && f.exists() && f.isDirectory() || f.mkdir())) {
                    f = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + this.outputFileDir);
                    f.mkdir();
                    this.outputFileDir = f.getAbsolutePath();
                }
            } else {
                this.outputFileDir = Environment.getExternalStorageDirectory().getAbsolutePath();
            }
            f = new File(this.outputFileDir, UUID.randomUUID() + ".png");
            out = new FileOutputStream(f);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)out);
            this.outputFilePath = f.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void setResult(Intent intent, int intentResult, String successPermission, String success, String imagePath) {
        JSONObject resultJson = new JSONObject();
        try {
            resultJson.put("success_permission", (Object)successPermission);
            resultJson.put("success", (Object)success);
            resultJson.put("qr_image_path", (Object)imagePath);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        intent.putExtra("RESPONSE", resultJson.toString());
        this.setResult(intentResult, intent);
    }
}

