/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.barcode;

import android.graphics.Rect;
import com.configureit.barcode.PreviewScalingStrategy;
import com.configureit.barcode.Size;

public class FitXYStrategy
extends PreviewScalingStrategy {
    private static final String TAG = FitXYStrategy.class.getSimpleName();

    private static float absRatio(float ratio) {
        if (ratio < 1.0f) {
            return 1.0f / ratio;
        }
        return ratio;
    }

    @Override
    protected float getScore(Size size, Size desired) {
        if (size.width <= 0 || size.height <= 0) {
            return 0.0f;
        }
        float scaleX = FitXYStrategy.absRatio((float)size.width * 1.0f / (float)desired.width);
        float scaleY = FitXYStrategy.absRatio((float)size.height * 1.0f / (float)desired.height);
        float scaleScore = 1.0f / scaleX / scaleY;
        float distortion = FitXYStrategy.absRatio(1.0f * (float)size.width / (float)size.height / (1.0f * (float)desired.width / (float)desired.height));
        float distortionScore = 1.0f / distortion / distortion / distortion;
        return scaleScore * distortionScore;
    }

    @Override
    public Rect scalePreview(Size previewSize, Size viewfinderSize) {
        return new Rect(0, 0, viewfinderSize.width, viewfinderSize.height);
    }
}

