/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.barcode;

import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import com.configureit.barcode.QRCodeEncoder;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;

public class GenerateQRCodeActivity
extends AppCompatActivity {
    public static final String REQ_ID = "req_id";
    public static final String INPUT_TEXT = "input";
    public static final String OUTPUT_WIDTH = "width";
    public static final String OUTPUT_HEIGHT = "height";
    public static final String OUTPUT_FILE_DIR = "SCAN_RESULT_IMAGE_STORAGE_DIR";
    private Intent intent;
    private String qrInputText;
    private String outputFileDir;
    private int width;
    private int height;
    private String outputFilePath;
    Runnable runnable = new Runnable(){

        @Override
        public void run() {
            int smallerDimension = GenerateQRCodeActivity.this.width < GenerateQRCodeActivity.this.height ? GenerateQRCodeActivity.this.width : GenerateQRCodeActivity.this.height;
            QRCodeEncoder qrCodeEncoder = new QRCodeEncoder(GenerateQRCodeActivity.this.qrInputText, null, "TEXT_TYPE", BarcodeFormat.QR_CODE.toString(), smallerDimension);
            try {
                Bitmap resultBitmap = qrCodeEncoder.encodeAsBitmap();
                GenerateQRCodeActivity.this.saveBitmapToFile(resultBitmap);
                GenerateQRCodeActivity.this.handler.sendEmptyMessage(0);
            }
            catch (WriterException e) {
                e.printStackTrace();
            }
        }
    };
    Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            if (!TextUtils.isEmpty((CharSequence)GenerateQRCodeActivity.this.outputFilePath)) {
                GenerateQRCodeActivity.this.intent.putExtra("result", GenerateQRCodeActivity.this.outputFilePath);
                GenerateQRCodeActivity.this.setResult(-1, GenerateQRCodeActivity.this.intent);
            } else {
                GenerateQRCodeActivity.this.intent.putExtra("result", GenerateQRCodeActivity.this.outputFilePath);
                GenerateQRCodeActivity.this.setResult(0, GenerateQRCodeActivity.this.intent);
            }
            GenerateQRCodeActivity.this.finish();
            return false;
        }
    });

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.intent = this.getIntent();
        this.qrInputText = this.intent.getExtras().getString(INPUT_TEXT, null);
        this.outputFileDir = this.intent.getExtras().getString(OUTPUT_FILE_DIR, null);
        this.width = this.intent.getExtras().getInt(OUTPUT_WIDTH, 255);
        this.height = this.intent.getExtras().getInt(OUTPUT_HEIGHT, 255);
        new Thread(this.runnable).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBitmapToFile(Bitmap bitmap) {
        FileOutputStream out = null;
        try {
            File f;
            if (!TextUtils.isEmpty((CharSequence)this.outputFileDir)) {
                f = new File(this.outputFileDir);
                if (!(f != null && f.exists() && f.isDirectory() || f.mkdir())) {
                    f = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + this.outputFileDir);
                    f.mkdir();
                    this.outputFileDir = f.getAbsolutePath();
                }
            } else {
                this.outputFileDir = Environment.getExternalStorageDirectory().getAbsolutePath();
            }
            f = new File(this.outputFileDir, UUID.randomUUID() + ".png");
            out = new FileOutputStream(f);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)out);
            this.outputFilePath = f.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

