package com.configureit.barcode;

import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.text.TextUtils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.UUID;

public class GenerateQRCodeActivity extends AppCompatActivity {


    public static final String REQ_ID  = "req_id";
    public static final String INPUT_TEXT  = "input";
    public static final String OUTPUT_WIDTH  = "width";
    public static final String OUTPUT_HEIGHT= "height";
    public static final String OUTPUT_FILE_DIR = "SCAN_RESULT_IMAGE_STORAGE_DIR";

    private Intent intent;
    private String qrInputText;
    private String outputFileDir;
    private int width, height;
    private String outputFilePath;



    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        intent = getIntent();

        qrInputText = intent.getExtras().getString(INPUT_TEXT, null);
        outputFileDir = intent.getExtras().getString(OUTPUT_FILE_DIR, null);
        width = intent.getExtras().getInt(OUTPUT_WIDTH, 255);
        height = intent.getExtras().getInt(OUTPUT_HEIGHT, 255);

        new Thread(runnable).start();
    }

    Runnable runnable = new Runnable() {
        @Override
        public void run() {
            int smallerDimension = width < height ? width : height;
//            smallerDimension = smallerDimension * 3/4;

            //Encode with a QR Code image
            QRCodeEncoder qrCodeEncoder = new QRCodeEncoder(qrInputText,
                    null,
                    Contents.Type.TEXT,
                    BarcodeFormat.QR_CODE.toString(),
                    smallerDimension);
            try {
                Bitmap resultBitmap = qrCodeEncoder.encodeAsBitmap();
                saveBitmapToFile(resultBitmap);
                handler.sendEmptyMessage(0);
            } catch (WriterException e) {
                e.printStackTrace();
            }
        }
    };

    Handler handler = new Handler(new Handler.Callback() {
        @Override
        public boolean handleMessage(Message msg) {
            if(!TextUtils.isEmpty(outputFilePath)) {
                intent.putExtra("result", outputFilePath);
                setResult(RESULT_OK, intent);
            }else{
                intent.putExtra("result", outputFilePath);
                setResult(RESULT_CANCELED, intent);
            }
            finish();
            return false;
        }
    });

    private void saveBitmapToFile(Bitmap bitmap){
        FileOutputStream out = null;
        try {
            if(!TextUtils.isEmpty(outputFileDir)){
                File f = new File(outputFileDir);
                if(f == null || !f.exists() || !f.isDirectory()){
                    if(!f.mkdir()){
                        f = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + "/"+ outputFileDir);
                        f.mkdir();
                        outputFileDir = f.getAbsolutePath();
                    }
                }
            }else{
                outputFileDir = Environment.getExternalStorageDirectory().getAbsolutePath();
            }

            File f = new File(outputFileDir, UUID.randomUUID() +".png");
            out = new FileOutputStream(f);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, out); // bmp is your Bitmap instance
            outputFilePath = f.getAbsolutePath();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (out != null) {
                    out.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
