/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.barcode;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import android.view.SurfaceHolder;
import com.configureit.barcode.CameraManager;
import com.configureit.barcode.CameraSettings;
import com.configureit.barcode.CameraSurface;
import com.configureit.barcode.CameraThread;
import com.configureit.barcode.DisplayConfiguration;
import com.configureit.barcode.PreviewCallback;
import com.configureit.barcode.Size;
import com.configureit.barcode.Util;
import com.configureit.utils.barcode.R;

public class CameraInstance {
    private static final String TAG = CameraInstance.class.getSimpleName();
    private CameraThread cameraThread;
    private CameraSurface surface;
    private CameraManager cameraManager;
    private Handler readyHandler;
    private DisplayConfiguration displayConfiguration;
    private boolean open = false;
    private CameraSettings cameraSettings = new CameraSettings();
    private Runnable opener = new Runnable(){

        @Override
        public void run() {
            try {
                Log.d((String)TAG, (String)"Opening camera");
                CameraInstance.this.cameraManager.open();
            }
            catch (Exception e) {
                CameraInstance.this.notifyError(e);
                Log.e((String)TAG, (String)"Failed to open camera", (Throwable)e);
            }
        }
    };
    private Runnable configure = new Runnable(){

        @Override
        public void run() {
            try {
                Log.d((String)TAG, (String)"Configuring camera");
                CameraInstance.this.cameraManager.configure();
                if (CameraInstance.this.readyHandler != null) {
                    CameraInstance.this.readyHandler.obtainMessage(R.id.zxing_prewiew_size_ready, (Object)CameraInstance.this.getPreviewSize()).sendToTarget();
                }
            }
            catch (Exception e) {
                CameraInstance.this.notifyError(e);
                Log.e((String)TAG, (String)"Failed to configure camera", (Throwable)e);
            }
        }
    };
    private Runnable previewStarter = new Runnable(){

        @Override
        public void run() {
            try {
                Log.d((String)TAG, (String)"Starting preview");
                CameraInstance.this.cameraManager.setPreviewDisplay(CameraInstance.this.surface);
                CameraInstance.this.cameraManager.startPreview();
            }
            catch (Exception e) {
                CameraInstance.this.notifyError(e);
                Log.e((String)TAG, (String)"Failed to start preview", (Throwable)e);
            }
        }
    };
    private Runnable closer = new Runnable(){

        @Override
        public void run() {
            try {
                Log.d((String)TAG, (String)"Closing camera");
                CameraInstance.this.cameraManager.stopPreview();
                CameraInstance.this.cameraManager.close();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Failed to close camera", (Throwable)e);
            }
            CameraInstance.this.cameraThread.decrementInstances();
        }
    };

    public CameraInstance(Context context) {
        Util.validateMainThread();
        this.cameraThread = CameraThread.getInstance();
        this.cameraManager = new CameraManager(context);
        this.cameraManager.setCameraSettings(this.cameraSettings);
    }

    public void setDisplayConfiguration(DisplayConfiguration configuration) {
        this.displayConfiguration = configuration;
        this.cameraManager.setDisplayConfiguration(configuration);
    }

    public DisplayConfiguration getDisplayConfiguration() {
        return this.displayConfiguration;
    }

    public void setReadyHandler(Handler readyHandler) {
        this.readyHandler = readyHandler;
    }

    public void setSurfaceHolder(SurfaceHolder surfaceHolder) {
        this.setSurface(new CameraSurface(surfaceHolder));
    }

    public void setSurface(CameraSurface surface) {
        this.surface = surface;
    }

    public CameraSettings getCameraSettings() {
        return this.cameraSettings;
    }

    public void setCameraSettings(CameraSettings cameraSettings) {
        if (!this.open) {
            this.cameraSettings = cameraSettings;
            this.cameraManager.setCameraSettings(cameraSettings);
        }
    }

    private Size getPreviewSize() {
        return this.cameraManager.getPreviewSize();
    }

    public int getCameraRotation() {
        return this.cameraManager.getCameraRotation();
    }

    public void open() {
        Util.validateMainThread();
        this.open = true;
        this.cameraThread.incrementAndEnqueue(this.opener);
    }

    public void configureCamera() {
        Util.validateMainThread();
        this.validateOpen();
        this.cameraThread.enqueue(this.configure);
    }

    public void startPreview() {
        Util.validateMainThread();
        this.validateOpen();
        this.cameraThread.enqueue(this.previewStarter);
    }

    public void setTorch(final boolean on) {
        Util.validateMainThread();
        if (this.open) {
            this.cameraThread.enqueue(new Runnable(){

                @Override
                public void run() {
                    CameraInstance.this.cameraManager.setTorch(on);
                }
            });
        }
    }

    public void close() {
        Util.validateMainThread();
        if (this.open) {
            this.cameraThread.enqueue(this.closer);
        }
        this.open = false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void requestPreview(final PreviewCallback callback) {
        this.validateOpen();
        this.cameraThread.enqueue(new Runnable(){

            @Override
            public void run() {
                CameraInstance.this.cameraManager.requestPreviewFrame(callback);
            }
        });
    }

    private void validateOpen() {
        if (!this.open) {
            throw new IllegalStateException("CameraInstance is not open");
        }
    }

    private void notifyError(Exception error) {
        if (this.readyHandler != null) {
            this.readyHandler.obtainMessage(R.id.zxing_camera_error, (Object)error).sendToTarget();
        }
    }
}

