/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.barcode;

import android.graphics.Rect;
import android.util.Log;
import com.configureit.barcode.Size;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class PreviewScalingStrategy {
    private static final String TAG = PreviewScalingStrategy.class.getSimpleName();

    public Size getBestPreviewSize(List<Size> sizes, Size desired) {
        List<Size> ordered = this.getBestPreviewOrder(sizes, desired);
        Log.i((String)TAG, (String)("Viewfinder size: " + desired));
        Log.i((String)TAG, (String)("Preview in order of preference: " + ordered));
        return ordered.get(0);
    }

    public List<Size> getBestPreviewOrder(List<Size> sizes, final Size desired) {
        if (desired == null) {
            return sizes;
        }
        Collections.sort(sizes, new Comparator<Size>(){

            @Override
            public int compare(Size a, Size b) {
                float aScore = PreviewScalingStrategy.this.getScore(a, desired);
                float bScore = PreviewScalingStrategy.this.getScore(b, desired);
                return Float.compare(bScore, aScore);
            }
        });
        return sizes;
    }

    protected float getScore(Size size, Size desired) {
        return 0.5f;
    }

    public abstract Rect scalePreview(Size var1, Size var2);
}

