/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.barcode;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.Display;
import android.view.Window;
import com.configureit.barcode.BarcodeCallback;
import com.configureit.barcode.BarcodeResult;
import com.configureit.barcode.BeepManager;
import com.configureit.barcode.CameraPreview;
import com.configureit.barcode.CompoundBarcodeView;
import com.configureit.barcode.InactivityTimer;
import com.configureit.utils.barcode.R;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class CaptureManager {
    private static final String TAG = CaptureManager.class.getSimpleName();
    private static int cameraPermissionReqCode = 250;
    private Activity activity;
    private CompoundBarcodeView barcodeView;
    private int orientationLock = -1;
    private static final String SAVED_ORIENTATION_LOCK = "SAVED_ORIENTATION_LOCK";
    private boolean returnBarcodeImagePath = false;
    private boolean destroyed = false;
    private static final long DELAY_BEEP = 150L;
    private InactivityTimer inactivityTimer;
    private BeepManager beepManager;
    private Handler handler;
    private BarcodeCallback callback = new BarcodeCallback(){

        @Override
        public void barcodeResult(final BarcodeResult result) {
            CaptureManager.this.barcodeView.pause();
            CaptureManager.this.beepManager.playBeepSoundAndVibrate();
            CaptureManager.this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    CaptureManager.this.returnResult(result);
                }
            }, 150L);
        }

        @Override
        public void possibleResultPoints(List<ResultPoint> resultPoints) {
        }
    };
    private final CameraPreview.StateListener stateListener = new CameraPreview.StateListener(){

        @Override
        public void previewSized() {
        }

        @Override
        public void previewStarted() {
        }

        @Override
        public void previewStopped() {
        }

        @Override
        public void cameraError(Exception error) {
            CaptureManager.this.displayFrameworkBugMessageAndExit();
        }
    };
    private boolean askedPermission = false;

    public CaptureManager(Activity activity, CompoundBarcodeView barcodeView) {
        this.activity = activity;
        this.barcodeView = barcodeView;
        barcodeView.getBarcodeView().addStateListener(this.stateListener);
        this.handler = new Handler();
        this.inactivityTimer = new InactivityTimer((Context)activity, new Runnable(){

            @Override
            public void run() {
                Log.d((String)TAG, (String)"Finishing due to inactivity");
                CaptureManager.this.finish();
            }
        });
        this.beepManager = new BeepManager(activity);
    }

    public void initializeFromIntent(Intent intent, Bundle savedInstanceState) {
        Window window = this.activity.getWindow();
        window.addFlags(128);
        if (savedInstanceState != null) {
            this.orientationLock = savedInstanceState.getInt(SAVED_ORIENTATION_LOCK, -1);
        }
        if (intent != null) {
            boolean orientationLocked;
            if (this.orientationLock == -1 && (orientationLocked = intent.getBooleanExtra("SCAN_ORIENTATION_LOCKED", true))) {
                this.lockOrientation();
            }
            if ("com.google.zxing.client.android.SCAN".equals(intent.getAction())) {
                this.barcodeView.initializeFromIntent(intent);
            }
            if (!intent.getBooleanExtra("BEEP_ENABLED", true)) {
                this.beepManager.setBeepEnabled(false);
                this.beepManager.updatePrefs();
            }
            if (intent.getBooleanExtra("BARCODE_IMAGE_ENABLED", false)) {
                this.returnBarcodeImagePath = true;
            }
        }
    }

    protected void lockOrientation() {
        if (this.orientationLock == -1) {
            Display display = this.activity.getWindowManager().getDefaultDisplay();
            int rotation = display.getRotation();
            int baseOrientation = this.activity.getResources().getConfiguration().orientation;
            int orientation = 0;
            if (baseOrientation == 2) {
                orientation = rotation == 0 || rotation == 1 ? 0 : 8;
            } else if (baseOrientation == 1) {
                orientation = rotation == 0 || rotation == 3 ? 1 : 9;
            }
            this.orientationLock = orientation;
        }
        this.activity.setRequestedOrientation(this.orientationLock);
    }

    public void decode() {
        this.barcodeView.decodeSingle(this.callback);
    }

    public void onResume() {
        if (Build.VERSION.SDK_INT >= 23) {
            this.openCameraWithPermission();
        } else {
            this.barcodeView.resume();
        }
        this.beepManager.updatePrefs();
        this.inactivityTimer.start();
    }

    @TargetApi(value=23)
    private void openCameraWithPermission() {
        if (ContextCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.CAMERA") == 0) {
            this.barcodeView.resume();
        } else if (!this.askedPermission) {
            ActivityCompat.requestPermissions((Activity)this.activity, (String[])new String[]{"android.permission.CAMERA"}, (int)cameraPermissionReqCode);
            this.askedPermission = true;
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == cameraPermissionReqCode) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.barcodeView.resume();
            } else {
                this.displayFrameworkBugMessageAndExit();
            }
        }
    }

    public void onPause() {
        this.barcodeView.pause();
        this.inactivityTimer.cancel();
        this.beepManager.close();
    }

    public void onDestroy() {
        this.destroyed = true;
        this.inactivityTimer.cancel();
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putInt(SAVED_ORIENTATION_LOCK, this.orientationLock);
    }

    public static Intent resultIntent(BarcodeResult rawResult, String barcodeImagePath) {
        Map<ResultMetadataType, Object> metadata;
        Intent intent = new Intent("com.google.zxing.client.android.SCAN");
        intent.addFlags(524288);
        intent.putExtra("SCAN_RESULT", rawResult.toString());
        intent.putExtra("SCAN_RESULT_FORMAT", rawResult.getBarcodeFormat().toString());
        byte[] rawBytes = rawResult.getRawBytes();
        if (rawBytes != null && rawBytes.length > 0) {
            intent.putExtra("SCAN_RESULT_BYTES", rawBytes);
        }
        if ((metadata = rawResult.getResultMetadata()) != null) {
            Iterable byteSegments;
            String ecLevel;
            Number orientation;
            if (metadata.containsKey(ResultMetadataType.UPC_EAN_EXTENSION)) {
                intent.putExtra("SCAN_RESULT_UPC_EAN_EXTENSION", metadata.get(ResultMetadataType.UPC_EAN_EXTENSION).toString());
            }
            if ((orientation = (Number)metadata.get(ResultMetadataType.ORIENTATION)) != null) {
                intent.putExtra("SCAN_RESULT_ORIENTATION", orientation.intValue());
            }
            if ((ecLevel = (String)metadata.get(ResultMetadataType.ERROR_CORRECTION_LEVEL)) != null) {
                intent.putExtra("SCAN_RESULT_ERROR_CORRECTION_LEVEL", ecLevel);
            }
            if ((byteSegments = (Iterable)metadata.get(ResultMetadataType.BYTE_SEGMENTS)) != null) {
                int i = 0;
                for (byte[] byteSegment : byteSegments) {
                    intent.putExtra("SCAN_RESULT_BYTE_SEGMENTS_" + i, byteSegment);
                    ++i;
                }
            }
        }
        if (barcodeImagePath != null) {
            intent.putExtra("SCAN_RESULT_IMAGE_PATH", barcodeImagePath);
        }
        return intent;
    }

    private String getBarcodeImagePath(BarcodeResult rawResult) {
        String barcodeImagePath = null;
        if (this.returnBarcodeImagePath) {
            Bitmap bmp = rawResult.getBitmap();
            try {
                File bitmapFile = File.createTempFile("barcodeimage", ".jpg", this.activity.getCacheDir());
                FileOutputStream outputStream = new FileOutputStream(bitmapFile);
                bmp.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)outputStream);
                outputStream.close();
                barcodeImagePath = bitmapFile.getAbsolutePath();
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)("Unable to create temporary file and store bitmap! " + e));
            }
        }
        return barcodeImagePath;
    }

    private void finish() {
        this.activity.finish();
    }

    protected void returnResult(BarcodeResult rawResult) {
        Intent intent = CaptureManager.resultIntent(rawResult, this.getBarcodeImagePath(rawResult));
        this.activity.setResult(-1, intent);
        this.finish();
    }

    protected void displayFrameworkBugMessageAndExit() {
        if (this.activity.isFinishing() || this.destroyed) {
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.activity);
        builder.setMessage((CharSequence)this.activity.getString(R.string.msg_camera_framework_bug));
        builder.setPositiveButton(R.string.button_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                CaptureManager.this.finish();
            }
        });
        builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                CaptureManager.this.finish();
            }
        });
        builder.show();
    }

    public static int getCameraPermissionReqCode() {
        return cameraPermissionReqCode;
    }

    public static void setCameraPermissionReqCode(int cameraPermissionReqCode) {
        CaptureManager.cameraPermissionReqCode = cameraPermissionReqCode;
    }
}

