/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.barcode;

import android.os.Handler;
import android.os.HandlerThread;

class CameraThread {
    private static final String TAG = CameraThread.class.getSimpleName();
    private static CameraThread instance;
    private Handler handler;
    private HandlerThread thread;
    private int openCount = 0;
    private final Object LOCK = new Object();

    public static CameraThread getInstance() {
        if (instance == null) {
            instance = new CameraThread();
        }
        return instance;
    }

    private CameraThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueue(Runnable runnable) {
        Object object = this.LOCK;
        synchronized (object) {
            this.checkRunning();
            this.handler.post(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueueDelayed(Runnable runnable, long delayMillis) {
        Object object = this.LOCK;
        synchronized (object) {
            this.checkRunning();
            this.handler.postDelayed(runnable, delayMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRunning() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.handler == null) {
                if (this.openCount <= 0) {
                    throw new IllegalStateException("CameraThread is not open");
                }
                this.thread = new HandlerThread("CameraThread");
                this.thread.start();
                this.handler = new Handler(this.thread.getLooper());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quit() {
        Object object = this.LOCK;
        synchronized (object) {
            this.thread.quit();
            this.thread = null;
            this.handler = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementInstances() {
        Object object = this.LOCK;
        synchronized (object) {
            --this.openCount;
            if (this.openCount == 0) {
                this.quit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementAndEnqueue(Runnable runner) {
        Object object = this.LOCK;
        synchronized (object) {
            ++this.openCount;
            this.enqueue(runner);
        }
    }
}

