package com.configureit.citpermissionlib;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.TextView;


public class PermissionDeniedDialog {

    private Activity activity;
    private PermissionDialogClickListener dialogClickListener;
    private Dialog dialog;

    public PermissionDeniedDialog(Activity context) {
        this.activity = context;
    }

    public void showPermissionErrorDialog(PermissionDialogClickListener listener) {
        showPermissionErrorDialog(null, null, null, null, listener);
    }

    public void showPermissionErrorDialog(String titleText, String messageText, PermissionDialogClickListener listener) {
        showPermissionErrorDialog(titleText, messageText, null, null, listener);
    }

    public void showPermissionErrorDialog(String titleText, String messageText, String positiveBtnText, String negativeBtnText, PermissionDialogClickListener listener) {
        try {
            if (dialog != null) {
                dialog.dismiss();
            }
            dialogClickListener = listener;
            AlertDialog.Builder alertDialog = new AlertDialog.Builder(activity, R.style.PermissionDialogTheme);
            LayoutInflater inflater = activity.getLayoutInflater();
            View v = inflater.inflate(R.layout.permission_denied_dialog, null);
            alertDialog.setView(v);
            if (dialog == null) {
                dialog = alertDialog.create();
            }

            LinearLayout positiveButton = v.findViewById(R.id.positive_button);
            LinearLayout negativeButton = v.findViewById(R.id.negative_button);

            TextView title = v.findViewById(R.id.title);
            TextView message = v.findViewById(R.id.message);

            if (!TextUtils.isEmpty(titleText)) {
                title.setText(titleText);
            }

            if (!TextUtils.isEmpty(messageText)) {
                message.setText(messageText);
            }

            if (!TextUtils.isEmpty(positiveBtnText)) {
                TextView btnPositive = v.findViewById(R.id.positive_txt);
                btnPositive.setText(positiveBtnText);
            }

            if (!TextUtils.isEmpty(negativeBtnText)) {
                TextView btnNegative = v.findViewById(R.id.negative_txt);
                btnNegative.setText(negativeBtnText);
            }
//            title.setTypeface(new FontTypeFace(activity).MontserratRegular());
//            title.setTypeface(new FontTypeFace(activity).MontserratRegular());
//            message.setTypeface(new FontTypeFace(activity).MontserratRegular());
//            negative_txt.setTypeface(new FontTypeFace(activity).MontserratRegular());
//            positive_txt.setTypeface(new FontTypeFace(activity).MontserratRegular());
            positiveButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    dialog.dismiss();
                    if (dialogClickListener != null)
                        dialogClickListener.positiveListener(activity, dialog);
                }
            });

            negativeButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    dialog.dismiss();
                    if (dialogClickListener != null)
                        dialogClickListener.negativeListener(activity, dialog);
                }
            });

            dialog.setOnKeyListener(new DialogInterface.OnKeyListener() {

                @Override
                public boolean onKey(DialogInterface dialog1,
                                     int keyCode, KeyEvent event) {
                    if (keyCode == KeyEvent.KEYCODE_BACK) {
                        dialog1.dismiss();
                        if (dialogClickListener != null)
                            dialogClickListener.negativeListener(activity, dialog);
                    }
                    return false;
                }
            });
//            if (dialog.getWindow() != null) {
//                dialog.getWindow().setBackgroundDrawableResource(android.R.color.transparent);
//                WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
//                lp.copyFrom(dialog.getWindow().getAttributes());
//                lp.width = WindowManager.LayoutParams.MATCH_PARENT;
//                lp.height = WindowManager.LayoutParams.WRAP_CONTENT;
//                lp.horizontalMargin = 20;
//                dialog.show();
//                dialog.getWindow().setAttributes(lp);
//            } else
            dialog.show();


        } catch (Exception e) {
            //catch exception
        }
    }
}
