/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.citpermissionlib;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import com.configureit.citpermissionlib.PermissionDeniedDialog;
import com.configureit.citpermissionlib.PermissionDialogClickListener;
import java.util.ArrayList;
import java.util.Locale;

public class PermissionUtils {
    private static final int REQ_PERMISSION = 38;
    private static final int REQUEST_PERMISSION_SETTING = 39;
    private String requestCode;
    private Activity activity;
    private String[] permissions;
    private PermissionCallback callback;

    private PermissionUtils(Activity activity) {
        this.activity = activity;
    }

    private void executeRequest() {
        ArrayList<String> requestedPermissions = new ArrayList<String>();
        for (String permission : this.permissions) {
            if (ContextCompat.checkSelfPermission((Context)this.activity, (String)permission) == 0) continue;
            requestedPermissions.add(permission);
        }
        if (requestedPermissions.size() > 0) {
            String[] arr = new String[requestedPermissions.size()];
            arr = requestedPermissions.toArray(arr);
            ActivityCompat.requestPermissions((Activity)this.activity, (String[])arr, (int)38);
        } else if (this.callback != null) {
            this.callback.onResult(this.requestCode, true, this.permissions, null, null);
        }
    }

    public void retry() {
        this.executeRequest();
    }

    public static void showExplicitPermissionSetting(Activity activity) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)activity.getPackageName(), null);
        intent.setData(uri);
        activity.startActivityForResult(intent, 39);
    }

    public void execute() {
        this.executeRequest();
    }

    public void onRequestPermissionsResult(int code, String[] permissions, int[] grantResults) {
        switch (code) {
            case 38: {
                if (grantResults == null || grantResults.length < 1) {
                    if (this.callback == null) break;
                    this.callback.onResult(this.requestCode, false, null, permissions, null);
                    break;
                }
                if (permissions.length <= 0) break;
                ArrayList<String> allows = new ArrayList<String>();
                ArrayList<String> denys = new ArrayList<String>();
                ArrayList<String> neverAskAgains = new ArrayList<String>();
                int i = 0;
                for (String permission : permissions) {
                    if (grantResults[i] == -1) {
                        boolean showRationale;
                        if (Build.VERSION.SDK_INT >= 23 && !(showRationale = this.activity.shouldShowRequestPermissionRationale(permission))) {
                            neverAskAgains.add(permission);
                            continue;
                        }
                        denys.add(permission);
                        continue;
                    }
                    allows.add(permission);
                }
                String[] arr1 = new String[allows.size()];
                String[] arr2 = new String[denys.size()];
                String[] arr3 = new String[neverAskAgains.size()];
                arr1 = allows.toArray(arr1);
                arr2 = allows.toArray(arr2);
                arr3 = allows.toArray(arr3);
                if (this.callback == null) break;
                boolean isSuccess = denys.size() == 0 && neverAskAgains.size() == 0;
                this.callback.onResult(this.requestCode, isSuccess, arr1, arr2, arr3);
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 39) {
            this.retry();
        }
    }

    public void showPermissionErrorDialog(PermissionDialogClickListener dialogClickListener) {
        this.showPermissionErrorDialog(null, null, dialogClickListener);
    }

    public void showPermissionErrorDialog(String title, String message, PermissionDialogClickListener dialogClickListener) {
        this.showPermissionErrorDialog(title, message, null, null, dialogClickListener);
    }

    public void showPermissionErrorDialog(String title, String message, String positiveBtnText, String negativeBtnText, final PermissionDialogClickListener dialogClickListener) {
        new PermissionDeniedDialog(this.activity).showPermissionErrorDialog(title, message, positiveBtnText, negativeBtnText, new PermissionDialogClickListener(){

            @Override
            public void positiveListener(Activity context, Dialog dialog) {
                PermissionUtils.showExplicitPermissionSetting(PermissionUtils.this.activity);
                if (dialogClickListener != null) {
                    dialogClickListener.positiveListener(PermissionUtils.this.activity, dialog);
                }
            }

            @Override
            public void negativeListener(Activity context, Dialog dialog) {
                if (dialogClickListener != null) {
                    dialogClickListener.negativeListener(PermissionUtils.this.activity, dialog);
                }
            }
        });
    }

    public static String[] getPermission(String permissions) {
        if (TextUtils.isEmpty((CharSequence)permissions)) {
            return null;
        }
        String[] s = permissions.split(",", 0);
        if (s != null && s.length > 0) {
            String[] permission = new String[s.length];
            for (int i = 0; i < s.length; ++i) {
                String newPermission;
                String per = s[i];
                permission[i] = newPermission = "android.permission." + per.toUpperCase(Locale.US);
            }
            return permission;
        }
        return null;
    }

    static /* synthetic */ String[] access$202(PermissionUtils x0, String[] x1) {
        x0.permissions = x1;
        return x1;
    }

    public static interface PermissionCallback {
        public void onResult(String var1, boolean var2, String[] var3, String[] var4, String[] var5);
    }

    public static class Builder {
        private PermissionUtils pu;

        public Builder(Activity activity, String requestCode) {
            this.pu = new PermissionUtils(activity);
            this.pu.requestCode = requestCode;
        }

        public Builder requestPermission(String ... permissions) {
            if (permissions == null || permissions.length < 1) {
                throw new IllegalArgumentException("You must specify atleast one permission for request");
            }
            PermissionUtils.access$202(this.pu, permissions);
            return this;
        }

        public Builder setCallback(PermissionCallback callback) {
            this.pu.callback = callback;
            return this;
        }

        public PermissionUtils build() {
            return this.pu;
        }
    }
}

