/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.citpermissionlib;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.configureit.citpermissionlib.PermissionDialogClickListener;
import com.configureit.citpermissionlib.R;

public class PermissionDeniedDialog {
    private Activity activity;
    private PermissionDialogClickListener dialogClickListener;
    private Dialog dialog;

    public PermissionDeniedDialog(Activity context) {
        this.activity = context;
    }

    public void showPermissionErrorDialog(PermissionDialogClickListener listener) {
        this.showPermissionErrorDialog(null, null, null, null, listener);
    }

    public void showPermissionErrorDialog(String titleText, String messageText, PermissionDialogClickListener listener) {
        this.showPermissionErrorDialog(titleText, messageText, null, null, listener);
    }

    public void showPermissionErrorDialog(String titleText, String messageText, String positiveBtnText, String negativeBtnText, PermissionDialogClickListener listener) {
        try {
            if (this.dialog != null) {
                this.dialog.dismiss();
            }
            this.dialogClickListener = listener;
            AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this.activity);
            LayoutInflater inflater = this.activity.getLayoutInflater();
            View v = inflater.inflate(R.layout.permission_denied_dialog, null);
            alertDialog.setView(v);
            if (this.dialog == null) {
                this.dialog = alertDialog.create();
            }
            LinearLayout positiveButton = (LinearLayout)v.findViewById(R.id.positive_button);
            LinearLayout negativeButton = (LinearLayout)v.findViewById(R.id.negative_button);
            TextView title = (TextView)v.findViewById(R.id.title);
            TextView message = (TextView)v.findViewById(R.id.message);
            if (!TextUtils.isEmpty((CharSequence)titleText)) {
                title.setText((CharSequence)titleText);
            }
            if (!TextUtils.isEmpty((CharSequence)messageText)) {
                message.setText((CharSequence)messageText);
            }
            if (!TextUtils.isEmpty((CharSequence)positiveBtnText)) {
                TextView btnPositive = (TextView)v.findViewById(R.id.positive_txt);
                btnPositive.setText((CharSequence)positiveBtnText);
            }
            if (!TextUtils.isEmpty((CharSequence)negativeBtnText)) {
                TextView btnNegative = (TextView)v.findViewById(R.id.negative_txt);
                btnNegative.setText((CharSequence)negativeBtnText);
            }
            positiveButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PermissionDeniedDialog.this.dialog.dismiss();
                    if (PermissionDeniedDialog.this.dialogClickListener != null) {
                        PermissionDeniedDialog.this.dialogClickListener.positiveListener(PermissionDeniedDialog.this.activity, PermissionDeniedDialog.this.dialog);
                    }
                }
            });
            negativeButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PermissionDeniedDialog.this.dialog.dismiss();
                    if (PermissionDeniedDialog.this.dialogClickListener != null) {
                        PermissionDeniedDialog.this.dialogClickListener.negativeListener(PermissionDeniedDialog.this.activity, PermissionDeniedDialog.this.dialog);
                    }
                }
            });
            alertDialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

                public boolean onKey(DialogInterface dialog1, int keyCode, KeyEvent event) {
                    if (keyCode == 4) {
                        dialog1.dismiss();
                        if (PermissionDeniedDialog.this.dialogClickListener != null) {
                            PermissionDeniedDialog.this.dialogClickListener.negativeListener(PermissionDeniedDialog.this.activity, PermissionDeniedDialog.this.dialog);
                        }
                    }
                    return false;
                }
            });
            this.dialog.show();
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

