/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.utils.alert;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.configureit.utils.alert.CITSnackListener;
import com.configureit.utils.alert.R;
import com.configureit.utils.alert.topsnackbar.SnackBar;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CITSnackBar {
    private View rootView;
    private CITSnackListener listner;
    private static SnackBar snackbar;
    private boolean isAutoDismiss = true;
    private boolean singleInstance = false;
    private int displayPosition = 1;
    private String message;
    private String requestCode;
    private String actionButton;
    private Context mContext;
    @ColorInt
    private int bgColor = Color.parseColor((String)"#515658");
    @ColorInt
    private int actionColor = Color.parseColor((String)"#FFCE46");
    @ColorInt
    private int messageColour = Color.parseColor((String)"#FFFFFF");
    private final String defaultMessage = "Alert..!";
    public static final int SHOW_ON_TOP = 0;
    public static final int SHOW_ON_BOTTOM = 1;
    private SnackBar.Callback snackBarListner = new SnackBar.Callback(){

        @Override
        public void onDismissed(SnackBar snackbar, int event) {
            super.onDismissed(snackbar, event);
            if (CITSnackBar.this.listner != null) {
                CITSnackBar.this.listner.onDismissSnack(CITSnackBar.this.requestCode);
            }
        }

        @Override
        public void onShown(SnackBar snackbar) {
            super.onShown(snackbar);
        }
    };

    protected CITSnackBar(@NonNull View rootView) {
        this.mContext = rootView.getContext();
        this.rootView = rootView;
    }

    public static CITSnackBar on(@NonNull View rootView) {
        return new CITSnackBar(rootView);
    }

    public CITSnackBar message(@NonNull String message) {
        this.message = message;
        return this;
    }

    public CITSnackBar withContext(@NonNull Context mContext) {
        this.mContext = mContext;
        return this;
    }

    public CITSnackBar actionTitle(@NonNull String actionButton) {
        this.actionButton = actionButton;
        return this;
    }

    public CITSnackBar messageTextColour(@NonNull String messageTextColour) {
        if (TextUtils.isEmpty((CharSequence)messageTextColour)) {
            return this;
        }
        this.messageColour = this.validateColour(messageTextColour, this.messageColour);
        return this;
    }

    public CITSnackBar setSingleInstance(boolean isSingleInstance) {
        this.singleInstance = isSingleInstance;
        return this;
    }

    public CITSnackBar messageTextColour(@ColorRes int messageTextColour) {
        if (messageTextColour == 0) {
            return this;
        }
        this.messageColour = Build.VERSION.SDK_INT >= 23 ? Resources.getSystem().getColor(messageTextColour, null) : Resources.getSystem().getColor(messageTextColour);
        return this;
    }

    public CITSnackBar actionTitleColor(@NonNull String actionTitleColour) {
        if (TextUtils.isEmpty((CharSequence)actionTitleColour)) {
            return this;
        }
        this.actionColor = this.validateColour(actionTitleColour, this.actionColor);
        return this;
    }

    public CITSnackBar actionTitleColor(@ColorRes int actionTitleColour) {
        if (actionTitleColour == 0) {
            return this;
        }
        this.actionColor = Build.VERSION.SDK_INT >= 23 ? Resources.getSystem().getColor(actionTitleColour, null) : Resources.getSystem().getColor(actionTitleColour);
        return this;
    }

    public CITSnackBar backgroundColour(@NonNull String bgColour) {
        if (TextUtils.isEmpty((CharSequence)bgColour)) {
            return this;
        }
        this.bgColor = this.validateColour(bgColour, this.bgColor);
        return this;
    }

    public CITSnackBar backgroundColour(@ColorRes int bgColour) {
        if (bgColour == 0) {
            return this;
        }
        this.bgColor = ActivityCompat.getColor((Context)this.mContext, (int)bgColour);
        return this;
    }

    public CITSnackBar displayAt(int displayPosition) {
        this.displayPosition = displayPosition;
        return this;
    }

    public CITSnackBar getCallBack(@NonNull String requestCode, @NonNull CITSnackListener listener) {
        this.requestCode = requestCode;
        this.listner = listener;
        return this;
    }

    public CITSnackBar getCallBack(@NonNull CITSnackListener listener) {
        this.listner = listener;
        return this;
    }

    public CITSnackBar setAutoDismiss(boolean isAutoDismiss) {
        this.isAutoDismiss = isAutoDismiss;
        return this;
    }

    public SnackBar show() {
        if (this.rootView == null) {
            throw new NullPointerException("Root view should not be null");
        }
        return this.createSnackBar();
    }

    private SnackBar createSnackBar() {
        if (this.singleInstance && snackbar != null && snackbar.isShown()) {
            return null;
        }
        String snackPosition = this.displayPosition == 0 ? "TOP" : "BOTTOM";
        int snackBarBehaviour = this.isAutoDismiss ? -1 : -2;
        snackBarBehaviour = snackBarBehaviour == -1 && !TextUtils.isEmpty((CharSequence)this.actionButton) ? -2 : snackBarBehaviour;
        View layout2 = snackPosition.equalsIgnoreCase("TOP") ? LayoutInflater.from((Context)this.mContext).inflate(R.layout.tsnackbar_top_layout, (ViewGroup)this.rootView, false) : LayoutInflater.from((Context)this.mContext).inflate(R.layout.tsnackbar_layout, (ViewGroup)this.rootView, false);
        snackbar = SnackBar.make(this.rootView, layout2, (CharSequence)CITSnackBar.getSpannableText(TextUtils.isEmpty((CharSequence)this.message) ? "Alert..!" : this.message, this.messageColour), snackBarBehaviour, snackPosition);
        if (!TextUtils.isEmpty((CharSequence)this.actionButton)) {
            snackbar.setAction(this.actionButton, new View.OnClickListener(){

                public void onClick(View v) {
                    if (CITSnackBar.this.listner != null) {
                        CITSnackBar.this.listner.onPerformClick(CITSnackBar.this.requestCode, CITSnackBar.this.actionButton);
                    }
                }
            });
        }
        snackbar.setActionTextColor(this.actionColor);
        snackbar.setCallback(this.snackBarListner);
        View snackBarView = snackbar.getView();
        snackBarView.setBackgroundColor(this.bgColor);
        snackbar.show();
        return snackbar;
    }

    private static SpannableStringBuilder getSpannableText(String msg, @ColorInt int textColour) {
        SpannableStringBuilder snackText = new SpannableStringBuilder();
        snackText.append((CharSequence)msg);
        snackText.setSpan((Object)new ForegroundColorSpan(textColour), 0, snackText.length(), 33);
        return snackText;
    }

    @ColorInt
    private int validateColour(String colourCode, @ColorInt int defaultColour) {
        int clrLength;
        if (!colourCode.startsWith("#")) {
            colourCode = "#" + colourCode;
        }
        return (clrLength = colourCode.length()) == 4 || clrLength == 5 || clrLength == 7 || clrLength == 9 ? Color.parseColor((String)colourCode) : defaultColour;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Position {
    }
}

