/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.utils.alert;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.design.widget.TextInputLayout;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.util.Log;
import android.util.Patterns;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.configureit.utils.alert.CITAlertListener;
import com.configureit.utils.alert.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;

public class CITAlert {
    private Context mContext;
    private String message;
    private String title;
    private String buttonPositive;
    private String buttonNegative;
    private String buttonNeutral;
    private String reQuestCode;
    private static AlertDialog alertDialog;
    private CITAlertListener listener;
    private View customView;
    private int alertType;
    private static Dialog dialog;
    private boolean isValidation = true;
    private boolean isCancelable = false;
    private boolean singleInstance = true;
    private String emptyEmailMessage = "Email should not be empty.";
    private String wrongEmailMessage = "Enter proper Email Address.";
    private String emptyPasswordMessage = "Password should not be empty.";
    @DrawableRes
    private int drawableIcon = 0;
    public static final int ALERT_TYPE_SIMPLE = 0;
    public static final int ALERT_TYPE_INPUT_PASSWORD = 1;
    public static final int ALERT_TYPE_INPUT_EMAIL = 2;
    public static final int ALERT_TYPE_INPUT_EMAIL_PASSWORD = 3;
    public static final int ALERT_TYPE_CUSTOM = 4;
    public static final int BUTTON_DISMISS = 0;
    public static final String BUTTON_DISMISS_TEXT = "cit_dismiss";
    private String emailPlaceHolder = "Enter Email";
    private String passwordPlaceHolder = "Enter password";
    private String emailText;
    private String passwordText;
    private EditText inputBox;
    private TextInputLayout inputLayout;

    protected CITAlert(@NonNull Context mContext) {
        this.mContext = mContext;
        if (mContext != null) {
            this.emptyEmailMessage = mContext.getString(R.string.cit_empty_email_dialog_message);
            this.wrongEmailMessage = mContext.getString(R.string.cit_valid_email_dialog_message);
            this.emptyPasswordMessage = mContext.getString(R.string.cit_empty_password_dialog_message);
            this.emailPlaceHolder = mContext.getString(R.string.cit_enter_email_dialog_hint);
            this.passwordPlaceHolder = mContext.getString(R.string.cit_enter_password_dialog_hint);
        }
    }

    public static CITAlert on(@NonNull Context context) {
        return new CITAlert(context);
    }

    public CITAlert setUp(@NonNull String title, @NonNull String message, @NonNull String buttonPositive, @NonNull String buttonNegative, @NonNull String buttonNeutral) {
        this.title = title;
        this.message = message;
        this.buttonPositive = buttonPositive;
        this.buttonNegative = buttonNegative;
        this.buttonNeutral = buttonNeutral;
        return this;
    }

    public CITAlert setUp(@NonNull String title, @NonNull String message, @NonNull String buttonPositive, @NonNull String buttonNegative) {
        this.title = title;
        this.message = message;
        this.buttonPositive = buttonPositive;
        this.buttonNegative = buttonNegative;
        return this;
    }

    public CITAlert setUp(@NonNull String title, @NonNull String message, @NonNull String buttonPositive) {
        this.title = title;
        this.message = message;
        this.buttonPositive = buttonPositive;
        return this;
    }

    public CITAlert title(@NonNull String title) {
        this.title = title;
        return this;
    }

    public CITAlert message(@NonNull String message) {
        this.message = message;
        return this;
    }

    public CITAlert buttonPositive(@NonNull String buttonPositive) {
        this.buttonPositive = buttonPositive;
        return this;
    }

    public CITAlert buttonNegative(@NonNull String buttonNegative) {
        this.buttonNegative = buttonNegative;
        return this;
    }

    public CITAlert buttonNeutral(@NonNull String buttonNeutral) {
        this.buttonNeutral = buttonNeutral;
        return this;
    }

    public CITAlert getCallBack(@NonNull String reQuestCode, @NonNull CITAlertListener listener) {
        this.reQuestCode = reQuestCode;
        this.listener = listener;
        return this;
    }

    public CITAlert getCallBack(@NonNull CITAlertListener listener) {
        this.listener = listener;
        return this;
    }

    public CITAlert alertType(int alertType) {
        this.alertType = alertType;
        return this;
    }

    public CITAlert setCustomView(@NonNull View view) {
        this.customView = view;
        return this;
    }

    public CITAlert setEmptyInputWarning(@NonNull String emptyInputWarning) {
        if (TextUtils.isEmpty((CharSequence)emptyInputWarning)) {
            return this;
        }
        this.emptyEmailMessage = emptyInputWarning;
        return this;
    }

    public CITAlert setEmptyPasswordWarning(@NonNull String emptyPasswordWarning) {
        if (TextUtils.isEmpty((CharSequence)emptyPasswordWarning)) {
            return this;
        }
        this.emptyPasswordMessage = emptyPasswordWarning;
        return this;
    }

    public CITAlert setWrongInputWarning(@NonNull String wrongInputWarning) {
        if (TextUtils.isEmpty((CharSequence)wrongInputWarning)) {
            return this;
        }
        this.wrongEmailMessage = wrongInputWarning;
        return this;
    }

    public CITAlert isInputValidationRequire(boolean isValidation) {
        this.isValidation = isValidation;
        return this;
    }

    public CITAlert setIcon(@DrawableRes int drawableIcon) {
        this.drawableIcon = drawableIcon;
        return this;
    }

    public CITAlert setCancelable(boolean isCancelable) {
        this.isCancelable = isCancelable;
        return this;
    }

    public CITAlert setSingleInstance(boolean isSingleInstance) {
        this.singleInstance = isSingleInstance;
        return this;
    }

    public CITAlert setEmailPlaceHolder(@NonNull String emailPlaceHolder) {
        this.emailPlaceHolder = !TextUtils.isEmpty((CharSequence)emailPlaceHolder) ? emailPlaceHolder : this.emailPlaceHolder;
        return this;
    }

    public CITAlert setPasswordPlaceHolder(@NonNull String passwordPlaceHolder) {
        this.passwordPlaceHolder = !TextUtils.isEmpty((CharSequence)passwordPlaceHolder) ? passwordPlaceHolder : this.passwordPlaceHolder;
        return this;
    }

    public CITAlert setEmailText(@NonNull String emailText) {
        this.emailText = emailText;
        return this;
    }

    public CITAlert setPasswordText(@NonNull String passwordText) {
        this.passwordText = passwordText;
        return this;
    }

    public Dialog show() {
        if (this.singleInstance && alertDialog != null && alertDialog.isShowing()) {
            return null;
        }
        if (this.alertType == 2 || this.alertType == 1) {
            dialog = this.createAlertWithInput();
        } else if (this.alertType == 3) {
            dialog = this.createAlertWithTwoInput();
        } else if (this.alertType == 4) {
            if (this.customView == null) {
                throw new NullPointerException("CIT CustomDialog view should not be empty.");
            }
            dialog = this.showDialogWithView();
        } else {
            dialog = this.createDialog();
        }
        return dialog;
    }

    public static void dismiss() {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
            dialog = null;
        }
    }

    private AlertDialog createDialog() {
        try {
            AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
            if (!TextUtils.isEmpty((CharSequence)this.title)) {
                builder.setTitle((CharSequence)this.title);
            }
            if (!TextUtils.isEmpty((CharSequence)this.message)) {
                builder.setMessage((CharSequence)this.message);
            }
            if (this.drawableIcon != 0) {
                builder.setIcon(this.drawableIcon);
            }
            if (!TextUtils.isEmpty((CharSequence)this.buttonPositive)) {
                builder.setPositiveButton((CharSequence)this.buttonPositive, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        alertDialog.dismiss();
                        if (CITAlert.this.listener != null) {
                            CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.this.buttonPositive, id2, "", "");
                        }
                    }
                });
            }
            if (!TextUtils.isEmpty((CharSequence)this.buttonNegative)) {
                builder.setNegativeButton((CharSequence)this.buttonNegative, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        alertDialog.dismiss();
                        if (CITAlert.this.listener != null) {
                            CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.this.buttonNegative, id2, "", "");
                        }
                    }
                });
            }
            if (!TextUtils.isEmpty((CharSequence)this.buttonNeutral)) {
                builder.setNeutralButton((CharSequence)this.buttonNeutral, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        alertDialog.dismiss();
                        if (CITAlert.this.listener != null) {
                            CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.this.buttonNeutral, id2, "", "");
                        }
                    }
                });
            }
            alertDialog = builder.create();
            alertDialog.setCancelable(this.isCancelable);
            alertDialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

                public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                    if (keyCode == 4) {
                        dialog.dismiss();
                        if (CITAlert.this.listener != null) {
                            CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.BUTTON_DISMISS_TEXT, 0, "", "");
                        }
                    }
                    return false;
                }
            });
            alertDialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return alertDialog;
    }

    private AlertDialog createAlertWithInput() {
        try {
            View inputDialogView;
            if (this.alertType == 2) {
                inputDialogView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.dialog_input, null);
                this.inputBox = (EditText)inputDialogView.findViewById(R.id.inputBoxEmail);
                this.inputLayout = (TextInputLayout)inputDialogView.findViewById(R.id.inputLayoutEmail);
                this.inputBox.setHint((CharSequence)this.emailPlaceHolder);
                this.inputLayout.setHint((CharSequence)this.emailPlaceHolder);
                if (!TextUtils.isEmpty((CharSequence)this.emailText)) {
                    this.inputBox.setText((CharSequence)this.emailText);
                }
            } else {
                inputDialogView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.dialog_input_secure, null);
                this.inputBox = (EditText)inputDialogView.findViewById(R.id.inputBoxPassword);
                this.inputLayout = (TextInputLayout)inputDialogView.findViewById(R.id.inputLayoutPassword);
                this.inputBox.setHint((CharSequence)this.passwordPlaceHolder);
                this.inputLayout.setHint((CharSequence)this.passwordPlaceHolder);
                if (!TextUtils.isEmpty((CharSequence)this.passwordText)) {
                    this.inputBox.setText((CharSequence)this.passwordText);
                }
            }
            TextView dialogTitle = (TextView)inputDialogView.findViewById(R.id.dialogTitle);
            if (TextUtils.isEmpty((CharSequence)this.title)) {
                dialogTitle.setVisibility(8);
            } else {
                dialogTitle.setVisibility(0);
                dialogTitle.setText((CharSequence)this.title);
            }
            AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext, 1);
            builder.setView(inputDialogView);
            if (this.drawableIcon != 0) {
                builder.setIcon(this.drawableIcon);
            }
            if (!TextUtils.isEmpty((CharSequence)this.buttonPositive)) {
                builder.setPositiveButton((CharSequence)this.buttonPositive, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                });
            }
            if (!TextUtils.isEmpty((CharSequence)this.buttonNegative)) {
                builder.setNegativeButton((CharSequence)this.buttonNegative, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        CITAlert.hideSoftKeyboard(CITAlert.this.mContext, (View)CITAlert.this.inputBox);
                        alertDialog.dismiss();
                        if (CITAlert.this.listener != null) {
                            CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.this.buttonNegative, -2, CITAlert.this.inputBox != null ? CITAlert.this.inputBox.getText().toString() : "", "");
                        }
                    }
                });
            }
            if (!TextUtils.isEmpty((CharSequence)this.buttonNeutral)) {
                builder.setNeutralButton((CharSequence)this.buttonNeutral, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        CITAlert.hideSoftKeyboard(CITAlert.this.mContext, (View)CITAlert.this.inputBox);
                    }
                });
            }
            alertDialog = builder.create();
            alertDialog.setCancelable(this.isCancelable);
            alertDialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

                public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                    if (keyCode == 4) {
                        CITAlert.hideSoftKeyboard(CITAlert.this.mContext, (View)CITAlert.this.inputBox);
                        dialog.dismiss();
                        if (CITAlert.this.listener != null) {
                            CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.BUTTON_DISMISS_TEXT, 0, "", "");
                        }
                    }
                    return false;
                }
            });
            alertDialog.setOnShowListener(new DialogInterface.OnShowListener(){

                public void onShow(final DialogInterface dialog) {
                    Button n = alertDialog.getButton(-3);
                    n.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            CITAlert.hideSoftKeyboard(CITAlert.this.mContext, (View)CITAlert.this.inputBox);
                            CITAlert.this.inputBox.setText((CharSequence)"");
                            CITAlert.this.inputLayout.setError(null);
                            if (CITAlert.this.listener != null) {
                                CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.this.buttonNeutral, -3, CITAlert.this.inputBox != null ? CITAlert.this.inputBox.getText().toString() : "", "");
                            }
                        }
                    });
                    n = alertDialog.getButton(-2);
                    n.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            CITAlert.hideSoftKeyboard(CITAlert.this.mContext, (View)CITAlert.this.inputBox);
                            dialog.dismiss();
                            CITAlert.this.inputBox.setText((CharSequence)"");
                            CITAlert.this.inputLayout.setError(null);
                            if (CITAlert.this.listener != null) {
                                CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.this.buttonNegative, -2, CITAlert.this.inputBox != null ? CITAlert.this.inputBox.getText().toString() : "", "");
                            }
                        }
                    });
                    Button p = alertDialog.getButton(-1);
                    p.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            if (CITAlert.this.inputBox != null) {
                                CITAlert.hideSoftKeyboard(CITAlert.this.mContext, (View)CITAlert.this.inputBox);
                                if (!CITAlert.this.isValidation) {
                                    dialog.dismiss();
                                    CITAlert.this.sendPositiveData(-1);
                                } else if (CITAlert.this.alertType == 1) {
                                    if (TextUtils.isEmpty((CharSequence)CITAlert.this.inputBox.getText())) {
                                        CITAlert.this.inputLayout.setError((CharSequence)CITAlert.this.emptyPasswordMessage);
                                    } else {
                                        dialog.dismiss();
                                        CITAlert.this.sendPositiveData(-1);
                                    }
                                } else if (CITAlert.this.alertType == 2) {
                                    if (TextUtils.isEmpty((CharSequence)CITAlert.this.inputBox.getText())) {
                                        CITAlert.this.inputLayout.setError((CharSequence)CITAlert.this.emptyEmailMessage);
                                    } else if (!Patterns.EMAIL_ADDRESS.matcher(CITAlert.this.inputBox.getText().toString().trim()).matches()) {
                                        CITAlert.this.inputLayout.setError((CharSequence)CITAlert.this.wrongEmailMessage);
                                    } else {
                                        dialog.dismiss();
                                        CITAlert.this.sendPositiveData(-1);
                                    }
                                }
                            } else {
                                dialog.dismiss();
                            }
                        }
                    });
                }
            });
            alertDialog.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return alertDialog;
    }

    private AlertDialog createAlertWithTwoInput() {
        try {
            View inputDialogView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.dialog_two_input, null);
            final EditText inputBoxEmail = (EditText)inputDialogView.findViewById(R.id.inputBoxEmail);
            final EditText inputBoxPassword = (EditText)inputDialogView.findViewById(R.id.inputBoxPassword);
            final TextInputLayout emailLayout = (TextInputLayout)inputDialogView.findViewById(R.id.inputLayoutEmail);
            final TextInputLayout passwordLayout = (TextInputLayout)inputDialogView.findViewById(R.id.inputLayoutPassword);
            TextView dialogTitle = (TextView)inputDialogView.findViewById(R.id.dialogTitle);
            inputBoxEmail.setHint((CharSequence)this.emailPlaceHolder);
            inputBoxPassword.setHint((CharSequence)this.passwordPlaceHolder);
            emailLayout.setHint((CharSequence)this.emailPlaceHolder);
            passwordLayout.setHint((CharSequence)this.passwordPlaceHolder);
            if (!TextUtils.isEmpty((CharSequence)this.emailText)) {
                inputBoxEmail.setText((CharSequence)this.emailText);
            }
            if (!TextUtils.isEmpty((CharSequence)this.passwordText)) {
                inputBoxPassword.setText((CharSequence)this.passwordText);
            }
            if (TextUtils.isEmpty((CharSequence)this.title)) {
                dialogTitle.setVisibility(8);
            } else {
                dialogTitle.setVisibility(0);
                dialogTitle.setText((CharSequence)this.title);
            }
            AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext, 1);
            builder.setView(inputDialogView);
            if (this.drawableIcon != 0) {
                builder.setIcon(this.drawableIcon);
            }
            if (!TextUtils.isEmpty((CharSequence)this.buttonPositive)) {
                builder.setPositiveButton((CharSequence)this.buttonPositive, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        CITAlert.hideSoftKeyboard(CITAlert.this.mContext, (View)inputBoxEmail);
                    }
                });
            }
            if (!TextUtils.isEmpty((CharSequence)this.buttonNegative)) {
                builder.setNegativeButton((CharSequence)this.buttonNegative, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        CITAlert.hideSoftKeyboard(CITAlert.this.mContext, (View)inputBoxEmail);
                        if (CITAlert.this.listener != null) {
                            CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.this.buttonNegative, which, "", "");
                        }
                        alertDialog.dismiss();
                    }
                });
            }
            if (!TextUtils.isEmpty((CharSequence)this.buttonNeutral)) {
                builder.setNeutralButton((CharSequence)this.buttonNeutral, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        CITAlert.hideSoftKeyboard(CITAlert.this.mContext, (View)inputBoxEmail);
                    }
                });
            }
            alertDialog = builder.create();
            alertDialog.setCancelable(this.isCancelable);
            alertDialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

                public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                    if (keyCode == 4) {
                        CITAlert.hideSoftKeyboard(CITAlert.this.mContext, (View)inputBoxEmail);
                        if (CITAlert.this.listener != null) {
                            CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.BUTTON_DISMISS_TEXT, 0, "", "");
                        }
                        dialog.dismiss();
                    }
                    return false;
                }
            });
            alertDialog.setOnShowListener(new DialogInterface.OnShowListener(){

                public void onShow(final DialogInterface dialog) {
                    Button n = alertDialog.getButton(-3);
                    n.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            CITAlert.hideSoftKeyboard(CITAlert.this.mContext, (View)inputBoxEmail);
                            inputBoxEmail.setText((CharSequence)"");
                            inputBoxPassword.setText((CharSequence)"");
                            emailLayout.setError(null);
                            passwordLayout.setError(null);
                            if (CITAlert.this.listener != null) {
                                CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.this.buttonNeutral, -3, inputBoxEmail != null ? inputBoxEmail.getText().toString() : "", inputBoxPassword != null ? inputBoxPassword.getText().toString() : "");
                            }
                        }
                    });
                    n = alertDialog.getButton(-2);
                    n.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            dialog.dismiss();
                            if (CITAlert.this.listener != null) {
                                CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.this.buttonNegative, -2, inputBoxEmail != null ? inputBoxEmail.getText().toString() : "", inputBoxPassword != null ? inputBoxPassword.getText().toString() : "");
                            }
                        }
                    });
                    Button p = alertDialog.getButton(-1);
                    p.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            if (inputBoxEmail != null && inputBoxPassword != null) {
                                CITAlert.hideSoftKeyboard(CITAlert.this.mContext, (View)inputBoxEmail);
                                if (!CITAlert.this.isValidation) {
                                    if (CITAlert.this.listener != null) {
                                        CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.this.buttonPositive, view.getId(), inputBoxEmail.getText().toString(), inputBoxPassword.getText().toString());
                                    }
                                    dialog.dismiss();
                                } else if (TextUtils.isEmpty((CharSequence)inputBoxEmail.getText())) {
                                    emailLayout.setError((CharSequence)CITAlert.this.emptyEmailMessage);
                                } else if (!Patterns.EMAIL_ADDRESS.matcher(inputBoxEmail.getText().toString().trim()).matches()) {
                                    emailLayout.setError((CharSequence)CITAlert.this.wrongEmailMessage);
                                } else if (TextUtils.isEmpty((CharSequence)inputBoxPassword.getText())) {
                                    emailLayout.setError((CharSequence)CITAlert.this.emptyPasswordMessage);
                                } else {
                                    Log.e((String)"Input-->", (String)inputBoxEmail.getText().toString());
                                    if (CITAlert.this.listener != null) {
                                        CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.this.buttonPositive, view.getId(), inputBoxEmail.getText().toString(), inputBoxPassword.getText().toString());
                                    }
                                    dialog.dismiss();
                                }
                            } else {
                                dialog.dismiss();
                            }
                        }
                    });
                }
            });
            alertDialog.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return alertDialog;
    }

    private void sendPositiveData(int id2) {
        if (this.listener != null) {
            if (this.alertType == 2) {
                this.listener.onPerformClick(this.reQuestCode, this.buttonPositive, id2, this.inputBox.getText().toString(), "");
            } else if (this.alertType == 1) {
                this.listener.onPerformClick(this.reQuestCode, this.buttonPositive, id2, "", this.inputBox.getText().toString());
            }
        }
    }

    private Dialog showDialogWithView() {
        try {
            dialog = new Dialog(this.mContext);
            dialog.requestWindowFeature(1);
            dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            dialog.setContentView(this.customView);
            dialog.setCancelable(this.isCancelable);
            dialog.setCanceledOnTouchOutside(this.isCancelable);
            WindowManager.LayoutParams windowLayout = dialog.getWindow().getAttributes();
            windowLayout.gravity = 17;
            dialog.show();
            dialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

                public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                    if (keyCode == 4) {
                        if (CITAlert.this.listener != null) {
                            CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.BUTTON_DISMISS_TEXT, 0, "", "");
                        }
                        dialog.dismiss();
                    }
                    return false;
                }
            });
            dialog.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dialog == null ? new Dialog(this.mContext) : dialog;
    }

    private void setErrorTextColor(TextInputLayout textInputLayout, int color) {
        try {
            Field fErrorView = TextInputLayout.class.getDeclaredField("mErrorView");
            fErrorView.setAccessible(true);
            TextView mErrorView = (TextView)fErrorView.get(textInputLayout);
            Field fCurTextColor = TextView.class.getDeclaredField("mCurTextColor");
            fCurTextColor.setAccessible(true);
            fCurTextColor.set(mErrorView, color);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void hideSoftKeyboard(Context context, View v) {
        if (v != null) {
            InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
            imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
        } else {
            EditText editText = new EditText(context);
            InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
            imm.hideSoftInputFromWindow(editText.getWindowToken(), 0);
        }
    }

    public static void showSoftKeyboard(Context context, View v) {
        if (v != null) {
            InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
            imm.showSoftInput(v, 1);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlertType {
    }
}

