package com.configureit.utils.alert;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.IntDef;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.configureit.utils.alert.topsnackbar.SnackBar;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * @author ConfigureIT Created on 14/4/16.
 *         Note:- Root view sholud be "CoordinatorLayout"
 */
public class CITSnackBar {

    private View rootView;
    private CITSnackListener listner;
    private static SnackBar snackbar;
    private boolean isAutoDismiss = true;
    private boolean singleInstance = false;
    private int displayPosition = SHOW_ON_BOTTOM;

    private String message;
    private String requestCode;
    private String actionButton;

    private Context mContext;

    @ColorInt
    private int bgColor = Color.parseColor("#515658");
    @ColorInt
    private int actionColor = Color.parseColor("#FFCE46");
    @ColorInt
    private int messageColour = Color.parseColor("#FFFFFF");

    private final String defaultMessage = "Alert..!";

    public static final int SHOW_ON_TOP = 0;
    public static final int SHOW_ON_BOTTOM = 1;

    @IntDef({SHOW_ON_TOP, SHOW_ON_BOTTOM})
    @Retention(RetentionPolicy.SOURCE)
    public @interface Position {
    }

    //Protected to prevent out side class Object creation
    protected CITSnackBar(@NonNull View rootView) {
        this.mContext = rootView.getContext();
        this.rootView = rootView;
    }

    /**
     * @param rootView
     * @return Class Instance
     */
    public static CITSnackBar on(@NonNull View rootView) {
        return new CITSnackBar(rootView);
    }

    /**
     * @param message
     * @return Class Instance
     */
    public CITSnackBar message(@NonNull String message) {
        this.message = message;
        return this;
    }

    /**
     * @param mContext
     * @return Class Instance
     */
    public CITSnackBar withContext(@NonNull Context mContext) {
        this.mContext = mContext;
        return this;
    }

    /**
     * @param actionButton
     * @return Class Instance
     */
    public CITSnackBar actionTitle(@NonNull String actionButton) {
        this.actionButton = actionButton;
        return this;
    }

    /**
     * @param messageTextColour
     * @return Class Instance
     */
    public CITSnackBar messageTextColour(@NonNull String messageTextColour) {
        if (TextUtils.isEmpty(messageTextColour)) return this;
        this.messageColour = validateColour(messageTextColour, messageColour);
        return this;
    }

    /**
     * @param isSingleInstance
     * @return Class Instance
     */
    public CITSnackBar setSingleInstance(boolean isSingleInstance) {
        this.singleInstance = isSingleInstance;
        return this;
    }

    /**
     * @param messageTextColour
     * @return Class Instance
     */
    public CITSnackBar messageTextColour(@ColorRes int messageTextColour) {
        if (messageTextColour == 0) return this;
        if (Build.VERSION.SDK_INT >= 23)
            this.messageColour = Resources.getSystem().getColor(messageTextColour, null);
        else
            this.messageColour = Resources.getSystem().getColor(messageTextColour);
//        this.messageTextColour = ActivityCompat.getColor(mContext, messageTextColour);
        return this;
    }

    /**
     * @param actionTitleColour
     * @return
     */
    public CITSnackBar actionTitleColor(@NonNull String actionTitleColour) {
        if (TextUtils.isEmpty(actionTitleColour)) return this;
        this.actionColor = validateColour(actionTitleColour, actionColor);
        return this;
    }

    /**
     * @param actionTitleColour
     * @return Class Instance
     */
    public CITSnackBar actionTitleColor(@ColorRes int actionTitleColour) {
        if (actionTitleColour == 0) return this;
        if (Build.VERSION.SDK_INT >= 23)
            this.actionColor = Resources.getSystem().getColor(actionTitleColour, null);
        else
            this.actionColor = Resources.getSystem().getColor(actionTitleColour);
//        this.actionTitleColor = ActivityCompat.getColor(mContext, actionTitleColour);
        return this;
    }

    /**
     * @param bgColour
     * @return
     */
    public CITSnackBar backgroundColour(@NonNull String bgColour) {
        if (TextUtils.isEmpty(bgColour)) return this;
        this.bgColor = validateColour(bgColour, bgColor);
        return this;
    }

    /**
     * @param bgColour
     * @return Class Instance
     */
    public CITSnackBar backgroundColour(@ColorRes int bgColour) {
        if (bgColour == 0) return this;
        this.bgColor = ActivityCompat.getColor(mContext, bgColour);
        return this;
    }

    /**
     * @param displayPosition
     * @return
     */
    public CITSnackBar displayAt(@Position int displayPosition) {
        this.displayPosition = displayPosition;
        return this;
    }

    /**
     * @param requestCode
     * @param listener
     * @return Class Instance
     */
    public CITSnackBar getCallBack(@NonNull String requestCode, @NonNull CITSnackListener listener) {
        this.requestCode = requestCode;
        this.listner = listener;
        return this;
    }

    /**
     * @param listener
     * @return
     */
    public CITSnackBar getCallBack(@NonNull CITSnackListener listener) {
        this.listner = listener;
        return this;
    }

    /**
     * @param isAutoDismiss
     * @return Class Instance
     */
    public CITSnackBar setAutoDismiss(boolean isAutoDismiss) {
        this.isAutoDismiss = isAutoDismiss;
        return this;
    }

    /**
     * @return
     */
    public SnackBar show() {
        if (rootView == null)
            throw new NullPointerException("Root view should not be null");
        return createSnackBar();
    }

    /**
     * @return SnackBar instance
     */
    private SnackBar createSnackBar() {
        if (singleInstance && snackbar != null && snackbar.isShown()) return null;
        String snackPosition = displayPosition == SHOW_ON_TOP ? SnackBar.SNACK_POSITION_TOP : SnackBar.SNACK_POSITION_BOTTOM;
        int snackBarBehaviour = isAutoDismiss ? SnackBar.LENGTH_SHORT : SnackBar.LENGTH_INDEFINITE;
        snackBarBehaviour = (snackBarBehaviour == SnackBar.LENGTH_SHORT && !TextUtils.isEmpty(actionButton))
                ? SnackBar.LENGTH_INDEFINITE : snackBarBehaviour;
        View layout;
        if (snackPosition.equalsIgnoreCase(SnackBar.SNACK_POSITION_TOP)) {
            layout = LayoutInflater.from(mContext).inflate(R.layout.tsnackbar_top_layout, (ViewGroup) rootView, false);
        } else {
            layout = LayoutInflater.from(mContext).inflate(R.layout.tsnackbar_layout, (ViewGroup) rootView, false);
        }
//        layout.setLayoutParams(new FrameLayout.LayoutParams(FrameLayout.LayoutParams.MATCH_PARENT, FrameLayout.LayoutParams.WRAP_CONTENT));

        snackbar = SnackBar.make(rootView, layout, getSpannableText(TextUtils.isEmpty(message)
                ? defaultMessage : message, messageColour), snackBarBehaviour, snackPosition);
        if (!TextUtils.isEmpty(actionButton))
            snackbar.setAction(actionButton, new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (listner != null)
                        listner.onPerformClick(requestCode, actionButton);
                }
            });

        snackbar.setActionTextColor(actionColor);
        snackbar.setCallback(snackBarListner);
        View snackBarView = snackbar.getView();
        snackBarView.setBackgroundColor(bgColor);
//        if (displayPosition == SHOW_ON_TOP) {
//            CoordinatorLayout.LayoutParams params = (CoordinatorLayout.LayoutParams)
// snackBarView.getLayoutParams();
//            params.gravity = Gravity.TOP;
//            snackBarView.setLayoutParams(params);
//        }
        snackbar.show();
        return snackbar;
    }

    /**
     *
     */
    private SnackBar.Callback snackBarListner = new SnackBar.Callback() {
        @Override
        public void onDismissed(SnackBar snackbar, int event) {
            super.onDismissed(snackbar, event);
            if (listner != null)
                listner.onDismissSnack(requestCode);
        }

        @Override
        public void onShown(SnackBar snackbar) {
            super.onShown(snackbar);
        }
    };

    /**
     * @param msg
     * @return
     */
    private static SpannableStringBuilder getSpannableText(String msg, @ColorInt int textColour) {
        SpannableStringBuilder snackText = new SpannableStringBuilder();
        snackText.append(msg);
        snackText.setSpan(new ForegroundColorSpan(textColour), 0, snackText.length(),
                Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
        return snackText;
    }

    /**
     * @param colourCode
     * @param defaultColour
     * @return
     */

    @ColorInt
    private int validateColour(String colourCode, @ColorInt int defaultColour) {
        if (!colourCode.startsWith("#"))
            colourCode = "#" + colourCode;
        int clrLength = colourCode.length();
        return (clrLength == 4 || clrLength == 5 || clrLength == 7 || clrLength == 9) ?
                Color.parseColor(colourCode) : defaultColour;
    }
}