/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.utils.alert;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.app.ActivityCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CITToast {
    private Context mContext;
    private String message = "Message..!";
    private int bgColor = -12303292;
    private int messageColor = -1;
    private int toastType = 0;
    private int toastDuration = 0;
    public static final int SIMPLE_TOAST = 0;
    public static final int CUSTOM_TOAST = 1;
    public static final int LENGTH_SHORT = 0;
    public static final int LENGTH_LONG = 1;

    protected CITToast(@NonNull Context mContext) {
        this.mContext = mContext;
    }

    public static CITToast on(@NonNull Context mContext) {
        return new CITToast(mContext);
    }

    public CITToast message(@NonNull String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return this;
        }
        this.message = message;
        return this;
    }

    public CITToast message(@StringRes int message) {
        if (TextUtils.isEmpty((CharSequence)this.mContext.getString(message))) {
            return this;
        }
        this.message = this.mContext.getString(message);
        return this;
    }

    public CITToast setbgColour(@NonNull String bgColour) {
        this.toastType = 1;
        this.bgColor = this.validateColour(bgColour, this.bgColor);
        return this;
    }

    public CITToast setbgColourResource(@ColorRes int bgColour) {
        this.toastType = 1;
        this.bgColor = ActivityCompat.getColor((Context)this.mContext, (int)bgColour);
        return this;
    }

    public CITToast setbgColour(@ColorInt int bgColour) {
        this.toastType = 1;
        this.bgColor = bgColour;
        return this;
    }

    public CITToast setMessageColour(@NonNull String messageColor) {
        this.toastType = 1;
        this.messageColor = this.validateColour(messageColor, this.messageColor);
        return this;
    }

    public CITToast setMessageColourResource(@ColorRes int messageColor) {
        this.toastType = 1;
        this.messageColor = ActivityCompat.getColor((Context)this.mContext, (int)messageColor);
        return this;
    }

    public CITToast setMessageColour(@ColorInt int messageColor) {
        this.toastType = 1;
        this.messageColor = messageColor;
        return this;
    }

    public CITToast setDuration(int duration) {
        this.toastDuration = duration;
        return this;
    }

    public void show() {
        if (this.toastType == 1) {
            Toast toast = new Toast(this.mContext);
            View view = this.getToastLayout();
            toast.setView(view);
            toast.setDuration(this.toastDuration == 0 ? 0 : 1);
            toast.show();
        } else {
            Toast.makeText((Context)this.mContext, (CharSequence)this.message, (int)(this.toastDuration == 0 ? 0 : 1)).show();
        }
    }

    @SuppressLint(value={"NewApi"})
    private View getToastLayout() {
        LinearLayout linearLayout = new LinearLayout(this.mContext);
        linearLayout.setOrientation(0);
        LinearLayout.LayoutParams imgParam = new LinearLayout.LayoutParams(-2, -2);
        imgParam.gravity = 17;
        TextView text = new TextView(this.mContext);
        text.setPadding(45, 20, 45, 20);
        text.setText((CharSequence)this.message);
        text.setTextSize(15.0f);
        text.setTextColor(this.messageColor);
        linearLayout.addView((View)text, (ViewGroup.LayoutParams)imgParam);
        GradientDrawable shape = new GradientDrawable();
        shape.setCornerRadius(50.0f);
        shape.setColor(this.bgColor);
        try {
            linearLayout.setBackground((Drawable)shape);
        }
        catch (Exception e) {
            linearLayout.setBackgroundDrawable((Drawable)shape);
        }
        catch (Error e) {
            linearLayout.setBackgroundDrawable((Drawable)shape);
        }
        return linearLayout;
    }

    @ColorInt
    private int validateColour(String colourCode, @ColorInt int defaultColour) {
        int clrLength;
        if (!colourCode.startsWith("#")) {
            colourCode = "#" + colourCode;
        }
        return (clrLength = colourCode.length()) == 4 || clrLength == 5 || clrLength == 7 || clrLength == 9 ? Color.parseColor((String)colourCode) : defaultColour;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Duration {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ToastType {
    }
}

