package com.configureit.utils.alert;

import android.content.res.Resources;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.IntDef;
import android.support.annotation.NonNull;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.Gravity;
import android.view.View;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * @author ConfigureIT Created on 14/4/16.
 *         <p/>
 *         Note:- Root view sholud be "CoordinatorLayout"
 */
public class CITSnackBar {

    private View rootView;
    private CITSnackListener listner;
    private boolean isAutoDismiss = true;
    private int displayPosition = SHOW_ON_BOTTOM;

    private String message;
    private String requestCode;
    private String actionButton;

    @ColorInt
    private int bgColor = Color.parseColor("#515658");
    @ColorInt
    private int actionColor = Color.parseColor("#FFCE46");
    @ColorInt
    private int messageColour = Color.parseColor("#FFFFFF");

    private final String defaultMessage = "Alert..!";

    public static final int SHOW_ON_TOP = 0;
    public static final int SHOW_ON_BOTTOM = 1;

    @IntDef({SHOW_ON_TOP, SHOW_ON_BOTTOM})
    @Retention(RetentionPolicy.SOURCE)
    public @interface Position {
    }

    //Protected to prevent out side class Object creation
    protected CITSnackBar(@NonNull View rootView) {
        this.rootView = rootView;
    }

    /**
     * @param rootView
     * @return
     */
    public static CITSnackBar on(@NonNull View rootView) {
        return new CITSnackBar(rootView);
    }

    /**
     * @param message
     * @return
     */
    public CITSnackBar message(@NonNull String message) {
        this.message = message;
        return this;
    }

    /**
     * @param actionButton
     * @return
     */
    public CITSnackBar actionTitle(@NonNull String actionButton) {
        this.actionButton = actionButton;
        return this;
    }

    /**
     * @param messageTextColour
     * @return
     */
    public CITSnackBar messageTextColour(@NonNull String messageTextColour) {
        if (TextUtils.isEmpty(messageTextColour)) return this;
        this.messageColour = validateColour(messageTextColour, messageColour);
        return this;
    }

    /**
     * @param messageTextColour
     * @return
     */
    public CITSnackBar messageTextColour(@ColorRes int messageTextColour) {
        if (messageTextColour == 0) return this;
        if (Build.VERSION.SDK_INT >= 23)
            this.messageColour = Resources.getSystem().getColor(messageTextColour, null);
        else
            this.messageColour = Resources.getSystem().getColor(messageTextColour);
//        this.messageTextColour = ActivityCompat.getColor(mContext, messageTextColour);
        return this;
    }

    /**
     * @param actionTitleColour
     * @return
     */
    public CITSnackBar actionTitleColor(@NonNull String actionTitleColour) {
        if (TextUtils.isEmpty(actionTitleColour)) return this;
        this.actionColor = validateColour(actionTitleColour, actionColor);
        return this;
    }

    /**
     * @param actionTitleColour
     * @return
     */
    public CITSnackBar actionTitleColor(@ColorRes int actionTitleColour) {
        if (actionTitleColour == 0) return this;
        if (Build.VERSION.SDK_INT >= 23)
            this.actionColor = Resources.getSystem().getColor(actionTitleColour, null);
        else
            this.actionColor = Resources.getSystem().getColor(actionTitleColour);
//        this.actionTitleColor = ActivityCompat.getColor(mContext, actionTitleColour);
        return this;
    }

    /**
     * @param bgColour
     * @return
     */
    public CITSnackBar backgroundColour(@NonNull String bgColour) {
        if (TextUtils.isEmpty(bgColour)) return this;
        this.bgColor = validateColour(bgColour, bgColor);
        return this;
    }

    /**
     * @param bgColour
     * @return
     */
    public CITSnackBar backgroundColour(@ColorRes int bgColour) {
        if (bgColour == 0) return this;
        if (Build.VERSION.SDK_INT >= 23)
            this.bgColor = Resources.getSystem().getColor(bgColour, null);
        else
            this.bgColor = Resources.getSystem().getColor(bgColour);
//        this.bgColor = ActivityCompat.getColor(mContext, bgColour);
        return this;
    }

    /**
     * @param displayPosition
     * @return
     */
    public CITSnackBar displayAt(@Position int displayPosition) {
        this.displayPosition = displayPosition;
        return this;
    }

    /**
     * @param requestCode
     * @param listener
     * @return
     */
    public CITSnackBar getCallBack(@NonNull String requestCode, @NonNull CITSnackListener listener) {
        this.requestCode = requestCode;
        this.listner = listener;
        return this;
    }

    /**
     * @param listener
     * @return
     */
    public CITSnackBar getCallBack(@NonNull CITSnackListener listener) {
        this.listner = listener;
        return this;
    }

    /**
     * @param isAutoDismiss
     * @return
     */
    public CITSnackBar setAutoDismiss(boolean isAutoDismiss) {
        this.isAutoDismiss = isAutoDismiss;
        return this;
    }

    /**
     * @return
     */
    public Object show() {
        if (rootView == null)
            throw new NullPointerException("Root view should not be null");
        return createSnackBar();
    }

    /**
     * @return
     */
    private Snackbar createSnackBar() {
        int snackBarBehaviour = isAutoDismiss ? Snackbar.LENGTH_SHORT : Snackbar.LENGTH_INDEFINITE;
        snackBarBehaviour = (snackBarBehaviour == Snackbar.LENGTH_SHORT && !TextUtils.isEmpty(actionButton))
                ? Snackbar.LENGTH_INDEFINITE : snackBarBehaviour;
        final Snackbar snackbar = Snackbar.make(rootView, getSpannableText(TextUtils.isEmpty(message)
                ? defaultMessage : message, messageColour), snackBarBehaviour);
        if (!TextUtils.isEmpty(actionButton))
            snackbar.setAction(actionButton, new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (listner != null)
                        listner.onPerformClick(requestCode, actionButton);
                }
            });
        snackbar.setActionTextColor(actionColor);
        snackbar.setCallback(snackBarListner);
        View snackBarView = snackbar.getView();
        snackBarView.setBackgroundColor(bgColor);
        if (displayPosition == SHOW_ON_TOP) {
            CoordinatorLayout.LayoutParams params = (CoordinatorLayout.LayoutParams) snackBarView.getLayoutParams();
            params.gravity = Gravity.TOP;
            snackBarView.setLayoutParams(params);
        }
        snackbar.show();
        return snackbar;
    }

    /**
     *
     */
    private Snackbar.Callback snackBarListner = new Snackbar.Callback() {
        @Override
        public void onDismissed(Snackbar snackbar, int event) {
            super.onDismissed(snackbar, event);
            if (listner != null)
                listner.onDismissSnack(requestCode);
        }

        @Override
        public void onShown(Snackbar snackbar) {
            super.onShown(snackbar);
        }
    };

    /**
     * @param msg
     * @return
     */
    private static SpannableStringBuilder getSpannableText(String msg, @ColorInt int textColour) {
        SpannableStringBuilder snackText = new SpannableStringBuilder();
        snackText.append(msg);
        snackText.setSpan(new ForegroundColorSpan(textColour), 0, snackText.length(),
                Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
        return snackText;
    }

    /**
     * @param colourCode
     * @param defaultColour
     * @return
     */

    @ColorInt
    private int validateColour(String colourCode, @ColorInt int defaultColour) {
        if (!colourCode.startsWith("#"))
            colourCode = "#" + colourCode;
        int clrLength = colourCode.length();
        return (clrLength == 4 || clrLength == 5 || clrLength == 7 || clrLength == 9) ?
                Color.parseColor(colourCode) : defaultColour;
    }
}
