/*
 * Decompiled with CFR 0.152.
 */
package com.configureit.utils.alert;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.util.Log;
import android.util.Patterns;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.configureit.utils.alert.CITAlertListener;
import com.configureit.utils.alert.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CITAlert {
    private Context mContext;
    private String message;
    private String title;
    private String buttonPositive;
    private String buttonNegative;
    private String buttonNeutral;
    private String reQuestCode;
    private String emptyInputWarning;
    private String wrongInputWarning;
    private AlertDialog alertDialog;
    private CITAlertListener listener;
    private int alertType;
    private Dialog dialog;
    private View customView;
    private final String defaultEmptyEmailMessage = "Enter proper Email Address.";
    private final String defaultWrongEmailMessage = "Email should not be empty.";
    public static final int ALERT_TYPE_SIMPLE = 0;
    public static final int ALERT_TYPE_INPUT = 1;
    public static final int ALERT_TYPE_CUSTOM = 2;

    protected CITAlert(Context mContext) {
        this.mContext = mContext;
    }

    public static CITAlert on(Context context) {
        return new CITAlert(context);
    }

    public CITAlert setUp(String title, String message, String buttonPositive, String buttonNegative, String buttonNeutral) {
        this.title = title;
        this.message = message;
        this.buttonPositive = buttonPositive;
        this.buttonNegative = buttonNegative;
        this.buttonNeutral = buttonNeutral;
        return this;
    }

    public CITAlert setUp(String title, String message, String buttonPositive, String buttonNegative) {
        this.title = title;
        this.message = message;
        this.buttonPositive = buttonPositive;
        this.buttonNegative = buttonNegative;
        return this;
    }

    public CITAlert setUp(String title, String message, String buttonPositive) {
        this.title = title;
        this.message = message;
        this.buttonPositive = buttonPositive;
        return this;
    }

    public CITAlert title(String title) {
        this.title = title;
        return this;
    }

    public CITAlert message(String message) {
        this.message = message;
        return this;
    }

    public CITAlert buttonPositive(String buttonPositive) {
        this.buttonPositive = buttonPositive;
        return this;
    }

    public CITAlert buttonNegative(String buttonNegative) {
        this.buttonNegative = buttonNegative;
        return this;
    }

    public CITAlert buttonNeutral(String buttonNeutral) {
        this.buttonNeutral = buttonNeutral;
        return this;
    }

    public CITAlert getCallBack(String reQuestCode, CITAlertListener listener) {
        this.reQuestCode = reQuestCode;
        this.listener = listener;
        return this;
    }

    public CITAlert getCallBack(CITAlertListener listener) {
        this.listener = listener;
        return this;
    }

    public CITAlert alertType(int alertType) {
        this.alertType = alertType;
        return this;
    }

    public CITAlert setCustomView(View view) {
        this.customView = view;
        return this;
    }

    public CITAlert setEmptyInputWarning(String emptyInputWarning) {
        this.emptyInputWarning = emptyInputWarning;
        return this;
    }

    public CITAlert setWrongInputWarning(String wrongInputWarning) {
        this.wrongInputWarning = wrongInputWarning;
        return this;
    }

    public Dialog show() {
        if (this.alertType == 1) {
            return this.createAlertWithInput();
        }
        if (this.alertType == 2) {
            if (this.customView == null) {
                throw new NullPointerException("CIT CustomDialog view should not be empty.");
            }
            return this.showDialogWithView();
        }
        return this.createDialog();
    }

    private AlertDialog createDialog() {
        try {
            AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
            if (!TextUtils.isEmpty((CharSequence)this.title)) {
                builder.setTitle((CharSequence)this.title);
            }
            if (!TextUtils.isEmpty((CharSequence)this.message)) {
                builder.setMessage((CharSequence)this.message);
            }
            if (!TextUtils.isEmpty((CharSequence)this.buttonPositive)) {
                builder.setPositiveButton((CharSequence)this.buttonPositive, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        if (CITAlert.this.listener != null) {
                            CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.this.buttonPositive, "");
                        }
                        CITAlert.this.alertDialog.dismiss();
                    }
                });
            }
            if (!TextUtils.isEmpty((CharSequence)this.buttonNegative)) {
                builder.setNegativeButton((CharSequence)this.buttonNegative, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        if (CITAlert.this.listener != null) {
                            CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.this.buttonNegative, "");
                        }
                        CITAlert.this.alertDialog.dismiss();
                    }
                });
            }
            if (!TextUtils.isEmpty((CharSequence)this.buttonNeutral)) {
                builder.setNeutralButton((CharSequence)this.buttonNeutral, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        if (CITAlert.this.listener != null) {
                            CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.this.buttonNeutral, "");
                        }
                        CITAlert.this.alertDialog.dismiss();
                    }
                });
            }
            this.alertDialog = builder.create();
            this.alertDialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

                public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                    if (keyCode == 4) {
                        if (CITAlert.this.listener != null) {
                            CITAlert.this.listener.onCancel(CITAlert.this.reQuestCode);
                        }
                        dialog.dismiss();
                    }
                    return false;
                }
            });
            this.alertDialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.alertDialog;
    }

    private AlertDialog createAlertWithInput() {
        try {
            View inputDialogView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.dialog_input, null);
            final EditText inputBox = (EditText)inputDialogView.findViewById(R.id.inputBox);
            TextView dialogTitle = (TextView)inputDialogView.findViewById(R.id.dialogTitle);
            if (TextUtils.isEmpty((CharSequence)this.title)) {
                dialogTitle.setVisibility(8);
            } else {
                dialogTitle.setVisibility(0);
                dialogTitle.setText((CharSequence)this.title);
            }
            AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext, 1);
            builder.setView(inputDialogView);
            if (!TextUtils.isEmpty((CharSequence)this.buttonPositive)) {
                builder.setPositiveButton((CharSequence)this.buttonPositive, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                });
            }
            if (!TextUtils.isEmpty((CharSequence)this.buttonNegative)) {
                builder.setNegativeButton((CharSequence)this.buttonNegative, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        if (CITAlert.this.listener != null) {
                            CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.this.buttonNegative, "");
                        }
                        CITAlert.this.alertDialog.dismiss();
                    }
                });
            }
            if (!TextUtils.isEmpty((CharSequence)this.buttonNeutral)) {
                builder.setNeutralButton((CharSequence)this.buttonNeutral, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                });
            }
            this.alertDialog = builder.create();
            this.alertDialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

                public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                    if (keyCode == 4) {
                        if (CITAlert.this.listener != null) {
                            CITAlert.this.listener.onCancel(CITAlert.this.reQuestCode);
                        }
                        dialog.dismiss();
                    }
                    return false;
                }
            });
            this.alertDialog.setOnShowListener(new DialogInterface.OnShowListener(){

                public void onShow(final DialogInterface dialog) {
                    Button n = CITAlert.this.alertDialog.getButton(-3);
                    n.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            inputBox.setText((CharSequence)"");
                            if (CITAlert.this.listener != null) {
                                CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.this.buttonNeutral, "");
                            }
                        }
                    });
                    Button p = CITAlert.this.alertDialog.getButton(-1);
                    p.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            if (inputBox != null) {
                                if (!TextUtils.isEmpty((CharSequence)inputBox.getText())) {
                                    if (Patterns.EMAIL_ADDRESS.matcher(inputBox.getText().toString().trim()).matches()) {
                                        Log.e((String)"Input-->", (String)inputBox.getText().toString());
                                        if (CITAlert.this.listener != null) {
                                            CITAlert.this.listener.onPerformClick(CITAlert.this.reQuestCode, CITAlert.this.buttonNegative, inputBox.getText().toString());
                                        }
                                        dialog.dismiss();
                                    } else {
                                        inputBox.setError((CharSequence)(TextUtils.isEmpty((CharSequence)CITAlert.this.wrongInputWarning) ? "Email should not be empty." : CITAlert.this.wrongInputWarning));
                                    }
                                } else {
                                    inputBox.setError((CharSequence)(TextUtils.isEmpty((CharSequence)CITAlert.this.emptyInputWarning) ? "Enter proper Email Address." : CITAlert.this.emptyInputWarning));
                                }
                            }
                        }
                    });
                }
            });
            this.alertDialog.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.alertDialog;
    }

    public Dialog showDialogWithView() {
        try {
            this.dialog = new Dialog(this.mContext);
            this.dialog.requestWindowFeature(1);
            this.dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.dialog.setContentView(this.customView);
            this.dialog.setCanceledOnTouchOutside(false);
            WindowManager.LayoutParams windowLayout = this.dialog.getWindow().getAttributes();
            windowLayout.gravity = 17;
            this.dialog.show();
            this.dialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

                public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                    if (keyCode == 4) {
                        if (CITAlert.this.listener != null) {
                            CITAlert.this.listener.onCancel(CITAlert.this.reQuestCode);
                        }
                        dialog.dismiss();
                    }
                    return false;
                }
            });
            this.dialog.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.dialog == null ? new Dialog(this.mContext) : this.dialog;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlertType {
    }
}

