/*
 * Decompiled with CFR 0.152.
 */
package com.comuto.flag;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.comuto.flag.FlagsCallback;
import com.comuto.flag.model.Flag;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import dagger.Lazy;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Inject;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public final class FlagsLoader {
    private static final String TAG = "FlagsLoader";
    private Lazy<OkHttpClient> lazyClient;
    private Gson gson;

    @Inject
    public FlagsLoader(Lazy<OkHttpClient> lazyClient, Gson gson) {
        this.lazyClient = lazyClient;
        this.gson = gson;
    }

    void load(String url, final @NonNull FlagsCallback flagsCallback) throws Exception {
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new IllegalStateException("Please pass a valid url");
        }
        Request request = new Request.Builder().url(url).build();
        ((OkHttpClient)this.lazyClient.get()).newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                Log.e((String)FlagsLoader.TAG, (String)("onFailure() called with: e = [" + e + "]"));
                e.printStackTrace();
                flagsCallback.onError();
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected code " + response);
                }
                Type listType = new TypeToken<List<Flag>>(){}.getType();
                String jsonStr = response.body().string();
                try {
                    List flags = (List)FlagsLoader.this.gson.fromJson(jsonStr, listType);
                    flagsCallback.onLoadFlags(jsonStr, flags);
                }
                catch (JsonSyntaxException exception) {
                    throw new IOException("JSON Bad Format " + exception.getMessage());
                }
            }
        });
    }
}

