/*
 * Decompiled with CFR 0.152.
 */
package com.comuto.flag;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import android.util.Log;
import com.comuto.flag.FlaggrComponent;
import com.comuto.flag.FlaggrManager;
import com.comuto.flag.FlagsCallback;
import com.comuto.flag.FlagsLoader;
import com.comuto.flag.model.Flag;
import com.comuto.flag.model.FlagContextInterface;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class Flaggr {
    private static final String TAG = "Flaggr";
    protected static final String FLAGGR_SHARED_PREFERENCES_PREFIX = "FLAGGR_PREF_ID_";
    private static final String FLAGS_PREF_KEY = "FLAGS_KEYS";
    @VisibleForTesting
    static volatile Flaggr singleton;
    @Inject
    FlagsLoader flagsLoader;
    @Inject
    SharedPreferences preferences;
    @Inject
    Gson gson;
    private List<Flag> flags;
    private final Map<String, Flag.FlagResultStatus> flagCaches = new HashMap<String, Flag.FlagResultStatus>();
    private String configUrl;
    private String defaultFlagsFileName;
    private final Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Flaggr with(Context context) {
        if (null != singleton) return singleton;
        Class<Flaggr> clazz = Flaggr.class;
        synchronized (Flaggr.class) {
            singleton = new Flaggr(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    private Flaggr(Context context) {
        if (null == context) {
            throw new IllegalArgumentException("Context must not be null.");
        }
        this.context = context.getApplicationContext();
        FlaggrComponent flaggrComponent = FlaggrComponent.Initializer.init(this.context);
        flaggrComponent.inject(this);
    }

    public void loadConfig(String configUrl, String defaultFlagsFileName) {
        this.configUrl = configUrl;
        this.defaultFlagsFileName = defaultFlagsFileName;
        this.downloadConfig(configUrl, defaultFlagsFileName);
    }

    public void reloadConfig() {
        this.downloadConfig(this.configUrl, this.defaultFlagsFileName);
    }

    private void downloadConfig(String configUrl, final String defaultFlagsFileName) {
        this.flagCaches.clear();
        try {
            this.loadLocalFlags(defaultFlagsFileName);
            this.flagsLoader.load(configUrl, new FlagsCallback(){

                @Override
                public void onLoadFlags(String jsonResponse, List<Flag> results) {
                    Flaggr.this.parseFlagJsonResults(jsonResponse, results);
                }

                @Override
                public void onError() {
                    Flaggr.this.loadLocalFlags(defaultFlagsFileName);
                }
            });
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Exception when loading config", (Throwable)ex);
        }
    }

    @VisibleForTesting
    public void parseFlagJsonResults(String jsonResponse, List<Flag> results) {
        if (jsonResponse == null || jsonResponse.isEmpty() || results == null || results.isEmpty()) {
            return;
        }
        this.flags = results;
        this.preferences.edit().putString(FLAGS_PREF_KEY, jsonResponse).apply();
    }

    private void loadLocalFlags(String defaultFlagsFileName) {
        String jsonResponse = this.readJSONFromAsset(defaultFlagsFileName);
        Type listType = new TypeToken<List<Flag>>(){}.getType();
        this.flags = (List)this.gson.fromJson(jsonResponse, listType);
        this.preferences.edit().putString(FLAGS_PREF_KEY, jsonResponse).apply();
    }

    @Nullable
    public String readJSONFromAsset(String fileName) {
        String json = null;
        try {
            InputStream is = this.context.getAssets().open(fileName);
            int size = is.available();
            byte[] buffer = new byte[size];
            is.read(buffer);
            is.close();
            json = new String(buffer, "UTF-8");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        return json;
    }

    public Flag.FlagResultStatus isActive(@StringRes int resId, FlagContextInterface flagContext) {
        return this.isActive(this.context.getString(resId), flagContext);
    }

    public Flag.FlagResultStatus isActive(String flagName, FlagContextInterface flagContext) {
        return this.isActive(flagName, flagContext, false);
    }

    public Flag.FlagResultStatus isActive(@NonNull String flagName, FlagContextInterface flagContext, boolean defaultValue) {
        if (TextUtils.isEmpty((CharSequence)flagName)) {
            return Flag.FlagResultStatus.UNKNOWN;
        }
        if (this.flagCaches.containsKey(flagName)) {
            return this.flagCaches.get(flagName);
        }
        if (null != this.flags && null != flagContext) {
            for (Flag flag : this.flags) {
                if (null == flag || null == flag.getName() || !flag.getName().equals(flagName)) continue;
                Flag.FlagResultStatus flagResultStatus = FlaggrManager.getFlagStatus(flag, flagContext, defaultValue);
                this.flagCaches.put(flagName, flagResultStatus);
                return flagResultStatus;
            }
        }
        Log.w((String)TAG, (String)("The flag " + flagName + " is not found."));
        return Flag.FlagResultStatus.UNKNOWN;
    }

    private String getPreferenceName(String flagName) {
        return FLAGGR_SHARED_PREFERENCES_PREFIX + flagName;
    }
}

